/**
 * =============================================================================
 * Expansion Board One - Example application No.1 (Version 0.0.1)
 * http://mbed.org/users/shintamainjp/notebook/starboard_expbrd-one_ex1_en/
 * =============================================================================
 * Copyright (c) 2010 Shinichiro Nakamura (CuBeatSystems)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * =============================================================================
 */

#include "mbed.h"
#include "TextLCD.h"
#include "EthernetNetIf.h"
#include "SuperTweetV1XML.h"
#include "ConfigFile.h"
#include "MyHomeLight.h"
#include "StreamFilter.h"
#include "TransmitterIR.h"
#include "appconf.h"
#include <string.h>

extern "C" void mbed_reset();

/*
 * Definitions for a configuration file.
 */
#define CONFIG_FILENAME         "/local/SBOE1.CFG"

/*
 * Variables.
 */
typedef struct {
    bool toggled;
    int fetch_count;
    int error_count;
    int toggle_count;
    int text_count;
    char txtcurr[1024];
    char txtprev[1024];
} work_t;
work_t work = {
    .toggled = false,
    .fetch_count = 0,
    .error_count = 0,
    .toggle_count = 0,
    .text_count = 0,
    .txtcurr = {0},
               .txtprev = {0}
                      };
static appconf_t appconf;
static const int CHANNEL = 2;

/*
 * Classes.
 */
LocalFileSystem localfs("local");
TextLCD lcd(p24, p26, p27, p28, p29, p30);
EthernetNetIf netif;
MyHomeLight room_light(p21);
StreamFilter sf("<text>", "</text>");

void splash(void);
int main(void);

/**
 * Display a splash screen.
 */
void splash(void) {
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("StarBoard Orange");
    lcd.locate(0, 1);
    lcd.printf("Expansion Board ");
    wait(2);

    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("Example app No.1");
    lcd.locate(0, 1);
    lcd.printf("                ");
    wait(2);
}

/**
 * A callback function with SuperTweet.
 *
 * @param buf A pointer to a buffer.
 * @param siz Size of the buffer.
 */
void cbfunc(char *buf, size_t siz) {
    /*
     * Push the stream data to the stream filter.
     */
    for (int i = 0; i < siz; i++) {
        sf.push(buf[i]);
    }

    /*
     * Check the state of the stream filter.
     */
    if (sf.done()) {
        if (sf.getContent(&work.txtcurr[0], sizeof(work.txtcurr))) {
            /*
             * Toggle my room light if there is a 'Light' text in twitter stream.
             */
            if (strstr(work.txtcurr, "Light") != NULL) {
                work.text_count++;
                if (work.text_count == 1) {
                    if (strcmp(work.txtcurr, work.txtprev) != 0) {
                        if (work.toggle_count > 0) {
                            if (room_light.toggle(CHANNEL)) {
                                printf("Controlled.\n");
                                work.toggled = true;
                            } else {
                                printf("Control failed.\n");
                            }
                        }
                        work.toggle_count++;
                    }
                    strcpy(work.txtprev, work.txtcurr);
                }
            }
        }
        sf.reset();
    }
}

/**
 * Entry point.
 */
int main(void) {

    /*
     * Splash.
     */
    splash();

    /*
     * Initialize ethernet interface.
     */
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("Initializing.   ");
    lcd.locate(0, 1);
    lcd.printf("Ethernet:       ");
    EthernetErr ethErr = netif.setup();
    if (ethErr) {
        lcd.locate(0, 1);
        lcd.printf("Ethernet:NG     ");
        error("Network setup failed.\n");
    } else {
        lcd.locate(0, 1);
        lcd.printf("Ethernet:OK     ");
    }
    wait(2);

    /*
     * Read configuration variables from a file.
     */
    appconf_init(&appconf);
    if (appconf_read(CONFIG_FILENAME, &appconf) != 0) {
        lcd.cls();
        lcd.locate(0, 0);
        lcd.printf("ConfigFile");
        lcd.locate(0, 1);
        lcd.printf("Read error.");
        error("Failure to read a configuration file.\n");
    }

    /*
     * Setup http client object.
     *
     * Please replace this information by your account.
     */
    SuperTweetV1XML twitter(appconf.account, appconf.password);

    int count = 0;
    while (1) {
        /*
         * Fetching...
         */
        lcd.cls();
        lcd.locate(0, 0);
        lcd.printf("Fetching:%d", count++);
        lcd.locate(0, 1);
        lcd.printf("Toggled :%d", work.toggle_count);

        work.fetch_count++;
        work.text_count = 0;
        work.toggled = false;
        sf.reset();

        /*
         * getStatusesUserTimeline: Only You can control a device.
         * getStatusesHomeTimeline: Everybody can control a device.
         */
        // HTTPResult r = twitter.getStatusesUserTimeline(cbfunc);
        HTTPResult r = twitter.getStatusesHomeTimeline(cbfunc);

        /*
         * Report the toggled status to the twitter account.
         */
        if (work.toggled) {
            work.toggled = false;
            char buf[64];
            snprintf(buf, sizeof(buf), "Toggled (%d/%d)", work.toggle_count, count);
            if (twitter.postStatusesUpdate(buf) == 0) {
                printf("Post done.\n");
            } else {
                printf("Post failed.\n");
            }
        }

        /*
         * Note:
         * I don't know why sometime it get a protocol error number 5.
         * I think it a bug in a mbed library.
         */
        printf("No.%d:[%d]\n", work.fetch_count, (int)r);
        if ((int)r != 0) {
            work.error_count++;
            if (work.error_count > 2) {
                printf("\tResetting...\n");
                mbed_reset();
            }
        }

        /*
         * Waiting...
         */
        lcd.cls();
        lcd.locate(0, 0);
        lcd.printf("Waiting...");
        wait(2);
    }
}
