/**
 * =============================================================================
 * Application configuration for 'Expansion Board One' example no.1
 * http://mbed.org/users/shintamainjp/notebook/starboard_expbrd-one_ex1_en/
 * =============================================================================
 * Copyright (c) 2010 Shinichiro Nakamura (CuBeatSystems)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * =============================================================================
 */

typedef struct {
    char account[64];
    char password[64];
} appconf_t;

/**
 * Initialize configuration.
 *
 * @param p A pointer to a application config.
 */
void appconf_init(appconf_t *p);

/**
 * Read configuration.
 *
 * @param filename Filename.
 * @param p A pointer to a application config.
 * @return Return zero if it succeed.
 */
int appconf_read(char *filename, appconf_t *p);

/**
 * Write configuration.
 *
 * @param filename Filename.
 * @param p A pointer to a application config.
 * @return Return zero if it succeed.
 */
int appconf_write(char *filename, appconf_t *p);
