/**
 * =============================================================================
 * My home light controller.
 * http://mbed.org/users/shintamainjp/notebook/starboard_expbrd-one_ex1_en/
 * =============================================================================
 * Copyright (c) 2010 Shinichiro Nakamura (CuBeatSystems)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * =============================================================================
 */

#include "mbed.h"
#include "TransmitterIR.h"

class MyHomeLight {
public:

    /**
     * Create.
     *
     * @param tx_pin Pin of IR transmitter.
     */
    explicit MyHomeLight(PinName tx_pin);

    /**
     * Dispose.
     */
    ~MyHomeLight();

    /**
     * Toggle state.
     *
     * @param channel Target channel number.
     * @return true if it succeed.
     */
    bool toggle(const int channel);

private:
    TransmitterIR tx;

    typedef struct {
        int channel;    /**< Channel number. */
        char *signal;   /**< Signal data. */
    } light_signal_t;

    /**
     * Signal for a light.
     */
    static const light_signal_t lights[8];

    /**
     * Get a signal for a light.
     *
     * @param channel Channel of a light.
     *
     * @return A pointer to a signal.
     */
    uint8_t *getLightSignal(int channel);
};
