/**
 * =============================================================================
 * My home light controller.
 * http://mbed.org/users/shintamainjp/notebook/starboard_expbrd-one_ex1_en/
 * =============================================================================
 * Copyright (c) 2010 Shinichiro Nakamura (CuBeatSystems)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * =============================================================================
 */

#include "MyHomeLight.h"
#include "RemoteIR.h"

const MyHomeLight::light_signal_t MyHomeLight::lights[8] = {
    {0, "\x2C\x52\x09\x02\x08\x82"},
    {1, "\x2C\x52\x09\x02\x0A\xA2"},
    {2, "\x2C\x52\x09\x02\x0C\xC2"},
    {3, "\x2C\x52\x09\x02\x0E\xE2"},
    {4, "\x2C\x52\x09\x42\x08\xC2"},
    {5, "\x2C\x52\x09\x42\x0A\xE2"},
    {6, "\x2C\x52\x09\x42\x0C\x82"},
    {7, "\x2C\x52\x09\x42\x0E\xA2"},
};

/**
 * Create.
 *
 * @param tx_pin Pin of IR transmitter.
 */
MyHomeLight::MyHomeLight(PinName tx_pin) : tx(tx_pin) {
}

/**
 * Dispose.
 */
MyHomeLight::~MyHomeLight() {
}

/**
 * Toggle state.
 *
 * @param channel Target channel number.
 * @return true if it succeed.
 */
bool MyHomeLight::toggle(const int channel) {
    RemoteIR::Format fmt = RemoteIR::AEHA;
    uint8_t *sig = getLightSignal(channel);
    if (sig != NULL) {
        for (int i = 0; i < 2; i++) {
            while (tx.getState() != TransmitterIR::Idle) {
                wait_us(100);
            }
            tx.setData(fmt, sig, 48);
            wait_ms(120);
        }
        return true;
    }
    return false;
}

/**
 * Get a signal for a light.
 *
 * @param channel Channel of a light.
 *
 * @return A pointer to a signal.
 */
uint8_t *MyHomeLight::getLightSignal(int channel) {
    const int n = sizeof(lights) / sizeof(lights[0]);
    if ((0 <= channel) && (channel <= n - 1)) {
        return (uint8_t *)lights[channel].signal;
    }
    return NULL;
}
