/**
 * =============================================================================
 * Stream filter for Twitter.
 * http://mbed.org/users/shintamainjp/notebook/starboard_expbrd-one_ex1_en/
 * =============================================================================
 * Copyright (c) 2010 Shinichiro Nakamura (CuBeatSystems)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * =============================================================================
 */

#include "StreamFilter.h"

/**
 * Create.
 *
 * @param headtxt Head of a target.
 * @param tailtxt Tail of a target.
 */
StreamFilter::StreamFilter(const char *headtxt, const char *tailtxt)
        : headcnt(0), tailcnt(0), head(headtxt), tail(tailtxt), content("") {
}

/**
 * Dispose.
 */
StreamFilter::~StreamFilter() {
}

/**
 * Check state of done.
 *
 * @return Return true if it done.
 */
bool StreamFilter::done() {
    if ((headcnt == strlen(head)) && (tailcnt == strlen(tail))) {
        return true;
    }
    return false;
}

/**
 * Reset state.
 */
void StreamFilter::reset() {
    headcnt = 0;
    tailcnt = 0;
    memset(content, 0, sizeof(content));
}

/**
 * Push a data to a internal buffer.
 *
 * @param c character.
 */
void StreamFilter::push(char c) {
    if (done()) {
        return;
    }

    /*
     * Check a text for the header.
     */
    if (headcnt < strlen(head)) {
        if (c == head[headcnt]) {
            headcnt++;
        } else {
            headcnt = 0;
        }
        return;
    }
    /*
     * Check a text for the tailer.
     */
    if (tailcnt < strlen(tail)) {
        if (c == tail[tailcnt]) {
            tailcnt++;
            return;
        } else {
            tailcnt = 0;
        }
    }
    /*
     * It's a content.
     */
    const int n = strlen(content);
    if (n < sizeof(content) - 1) {
        content[n + 0] = c;
        content[n + 1] = '\0';
    }
}

/**
 * Get a content text.
 *
 * @param buf A pointer to a buffer.
 * @param bufsiz Size of the buffer.
 *
 * @return true if it succeed.
 */
bool StreamFilter::getContent(char *buf, size_t bufsiz) {
    if (strlen(content) < bufsiz) {
        strcpy(buf, content);
        return true;
    }
    return false;
}
