#include "appconf.h"
#include <ConfigFile.h>

LocalFileSystem fs_local("local");

#define CONFIG_FILENAME "/local/SETUP.CFG"

#define KEY_CHANNEL "Channel"
#define VALUE_CHANNEL_A "A"
#define VALUE_CHANNEL_B "B"
#define VALUE_CHANNEL_C "C"
#define VALUE_CHANNEL_D "D"

/**
 * Initialize a configuration.
 *
 * @param p A pointer to a configuration structure.
 */
void appconf_init(appconf_t *p) {
    /*
     * Channel default value is a channel C.
     */
    p->channel = ChoroQ::ChC;
}

/**
 * Read a configuration.
 *
 * @param p A pointer to a configuration structure.
 *
 * @return Return 0 if read succeed.
 */
int appconf_read(appconf_t *p) {
    ConfigFile cfg;
    
    if (!cfg.read(CONFIG_FILENAME)) {
        return -1;
    }
    
    char *key = KEY_CHANNEL;
    char value[64];
    if (!cfg.getValue(key, value, sizeof(value))) {
        return -2;
    }
    
    if (strcmp(value, VALUE_CHANNEL_A) == 0) {
        p->channel = ChoroQ::ChA;
    } else if (strcmp(value, VALUE_CHANNEL_B) == 0) {
        p->channel = ChoroQ::ChB;
    } else if (strcmp(value, VALUE_CHANNEL_C) == 0) {
        p->channel = ChoroQ::ChC;
    } else if (strcmp(value, VALUE_CHANNEL_D) == 0) {
        p->channel = ChoroQ::ChD;
    } else {
        return -3;
    }
    
    return 0;
}
