/**
 * GoogleChart API interface driver. (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "GoogleChart.h"

const std::string GoogleChart::baseURL = "http://chart.apis.google.com/chart";

GoogleChart::GoogleChart() : title(""), width(300), height(225) {
    for (int i = 0; i < MAX_AXIS; i++) {
        axislist[i] = 0;
    }
    for (int i = 0; i < MAX_DATA; i++) {
        datalist[i] = 0;
    }
}

GoogleChart::~GoogleChart() {}

int GoogleChart::addNewAxis(Axis::Type type) {
    /*
     * Search maximum number of axis.
     */
    int max = 0;
    for (int i = 0; i < MAX_AXIS; i++) {
        if (0 != axislist[i]) {
            if (axislist[i]->getNumber() > max) {
                max = axislist[i]->getNumber();
            }
        }
    }

    /*
     * Create a new axis.
     */
    for (int i = 0; i < MAX_AXIS; i++) {
        if (0 == axislist[i]) {
            axislist[i] = new Axis(max + 1, type);
            return max + 1;
        }
    }
    return -1;
}

int GoogleChart::setAxisType(const int number, Axis::Type type) {
    for (int i = 0; i < MAX_AXIS; i++) {
        if (0 != axislist[i]) {
            if (axislist[i]->getNumber() == number) {
                axislist[i]->setType(type);
                return number;
            }
        }
    }
    return -1;
}

int GoogleChart::setAxisRange(const int number, int rangeStart, int rangeEnd) {
    for (int i = 0; i < MAX_AXIS; i++) {
        if (0 != axislist[i]) {
            if (axislist[i]->getNumber() == number) {
                axislist[i]->setRangeStart(rangeStart);
                axislist[i]->setRangeEnd(rangeEnd);
                return number;
            }
        }
    }
    return -1;
}

int GoogleChart::removeAxis(const int number) {
    for (int i = 0; i < MAX_AXIS; i++) {
        if (0 != axislist[i]) {
            if (axislist[i]->getNumber() == number) {
                delete axislist[i];
                axislist[i] = 0;
                return number;
            }
        }
    }
    return -1;
}

int GoogleChart::addNewDataSet(std::string label, const int size) {
    /*
     * Search maximum number of data set.
     */
    int max = 0;
    for (int i = 0; i < MAX_DATA; i++) {
        if (0 != datalist[i]) {
            if (datalist[i]->getNumber() > max) {
                max = datalist[i]->getNumber();
            }
        }
    }

    /*
     * Create a new data set.
     */
    for (int i = 0; i < MAX_DATA; i++) {
        if (0 == datalist[i]) {
            datalist[i] = new DataSet(label, max + 1, size);
            return max + 1;
        }
    }
    return -1;
}

int GoogleChart::removeDataSet(const int number) {
    for (int i = 0; i < MAX_DATA; i++) {
        if (0 != datalist[i]) {
            if (datalist[i]->getNumber() == number) {
                delete datalist[i];
                datalist[i] = 0;
                return number;
            }
        }
    }
    return -1;
}

int GoogleChart::addData(const int number, double data) {
    for (int i = 0; i < MAX_DATA; i++) {
        if (0 != datalist[i]) {
            if (datalist[i]->getNumber() == number) {
                datalist[i]->addData(data);
                return i;
            }
        }
    }
    return -1;
}

int GoogleChart::clearAllData(const int number) {
    for (int i = 0; i < MAX_DATA; i++) {
        if (0 != datalist[i]) {
            if (datalist[i]->getNumber() == number) {
                datalist[i]->clearAllData();
                return i;
            }
        }
    }
    return -1;
}

    int GoogleChart::setDataScale(const int number, int min, int max) {
    for (int i = 0; i < MAX_DATA; i++) {
        if (0 != datalist[i]) {
            if (datalist[i]->getNumber() == number) {
                datalist[i]->setScale(min, max);
                return i;
            }
        }
    }
    return -1;
    }

void GoogleChart::setTitle(std::string title) {
    GoogleChart::title = title;
}

std::string GoogleChart::getTitle() const {
    return title;
}

void GoogleChart::setWidth(int width) {
    GoogleChart::width = width;
}

int GoogleChart::getWidth() const {
    return width;
}

void GoogleChart::setHeight(int height) {
    GoogleChart::height = height;
}

int GoogleChart::getHeight() const {
    return height;
}

std::string GoogleChart::toURL(std::string text) {
    static const char *unsafe_characters = " \"<>#%{}|\\^~[]`";
    std::string s = "";
    for (int i = 0; i < text.length(); i++) {
        char c = text.at(i);
        if (strchr(unsafe_characters, c) == NULL) {
            s = s + c;
        } else {
            char buf[8];
            snprintf(buf, sizeof(buf), "%%%02X", c & 0xff);
            s = s + std::string(buf);
        }
    }
    return s;
}

std::string GoogleChart::paramChartType(ChartType chartType) {
    /*
     * Chart Type.
     */
    std::string s = "cht=";
    switch (chartType) {
        case LineChart:
            s = s + "lc";
            break;
        default:
            s = s + "unknown";
            break;
    }
    return s;
}

std::string GoogleChart::paramAxis(Axis **list, int size) {

    char buf[64];
    /*
     * Axis type and range.
     */
    int cnt = 0;
    std::string sType = "chxt=";
    std::string sRange = "chxr=";
    for (int i = 0; i < size; i++) {
        Axis *p = list[i];
        if (0 != p) {
            /*
             * Type.
             */
            if (0 < cnt) {
                sType = sType + ",";
            }
            switch (p->getType()) {
                case Axis::Bottom:
                    sType = sType + "x";
                    break;
                case Axis::Left:
                    sType = sType + "y";
                    break;
                case Axis::Right:
                    sType = sType + "r";
                    break;
                case Axis::Top:
                    sType = sType + "t";
                    break;
                default:
                    sType = sType + "?";
                    break;
            }
            /*
             * Range.
             */
            if (0 < cnt) {
                sRange = sRange + "|";
            }
            snprintf(buf, sizeof(buf), "%d,%d,%d", cnt, p->getRangeStart(), p->getRangeEnd());
            sRange = sRange + std::string(buf);
            /*
             * Next.
             */
            cnt++;
        }
    }

    return sRange + "&" + sType;
}

std::string GoogleChart::paramDataSet(DataSet **list, int size) {
    char buf[64];
    int cnt = 0;
    std::string sData = "chd=t:";
    std::string sScale = "chds=";
    std::string sLabel = "chdl=";
    for (int i = 0; i < size; i++) {
        DataSet *p = list[i];
        if (0 != p) {
            /*
             * Data.
             */
            if (0 < cnt) {
                sData = sData + "|";
            }
            for (int i = 0; i < p->getDataCount(); i++) {
                double d = p->getData(i);
                snprintf(buf, sizeof(buf), "%.3f", d);
                if (0 < i) {
                    sData = sData + ",";
                }
                sData = sData + std::string(buf);
            }
            /*
             * Range.
             */
            if (0 < cnt) {
                sScale = sScale + ",";
            }
            snprintf(buf, sizeof(buf), "%.3f,%.3f", p->getMin(), p->getMax());
            sScale = sScale + std::string(buf);
            /*
             * Label.
             */
            if (0 < cnt) {
                sLabel = sLabel + "|";
            }
            sLabel = sLabel + p->getLabel();
            /*
             * Next.
             */
            cnt++;
        }
    }

    return sScale + "&" + sData + "&" + sLabel;
}

std::string GoogleChart::paramTitle(std::string title, int color, double fontSize) {
    char buf[64];
    std::string s = "";
    /*
     * Chart Title Text.
     */
    s = s + "chtt=" + title;
    /*
     * Chart Title Specification.
     */
    snprintf(buf, sizeof(buf), "&chts=%06X,%.1f", color, fontSize);
    s = s + std::string(buf);
    return s;
}

std::string GoogleChart::paramSize(int width, int height) {
    char buf[64];
    /*
     * Chart Size.
     */
    snprintf(buf, sizeof(buf), "chs=%dx%d", width, height);
    return std::string(buf);
}
