/**
 * GoogleChart API interface driver. (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "DataSet.h"

DataSet::DataSet(std::string label, int number, int size, DataSet::EncodeType encodeType)
        :
        label(label), number(number), size(size), encodeType(encodeType), dataCount(0), min(0), max(100) {
    datalist = new double[size];
}

DataSet::~DataSet() {
    delete [] datalist;
}

std::string DataSet::getLabel() {
    return label;
}

int DataSet::getNumber() {
    return number;
}

int DataSet::getSize() {
    return size;
}

void DataSet::setEncodeType(DataSet::EncodeType encodeType) {
    DataSet::encodeType = encodeType;
}

DataSet::EncodeType DataSet::getEncodeType() {
    return encodeType;
}

void DataSet::clearAllData() {
    dataCount = 0;
}

void DataSet::addData(double data) {
    datalist[dataCount++] = data;
}

int DataSet::getDataCount() {
    return dataCount;
}

double DataSet::getData(int index) {
    return datalist[index];
}
