/**
 * StarBoard Orange - Example application No.1 (Version 0.0.1)
 * GoogleChartLogger with StarBoard Orange
 * See also ... http://mbed.org/users/shintamainjp/notebook/starboard_example1_ja/
 * See also ... http://mbed.org/users/shintamainjp/notebook/starboard_example1_en/
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */
#include "mbed.h"
#include "SDFileSystem.h"
#include "TextLCD.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "SensorLM60.h"
#include "SensorLM35.h"
#include "SensorMCP9700.h"
#include "SensorDummy.h"
#include "GoogleChartLineChart.h"

#define SUPERTWEET_ACCOUNT  "YourAccount"
#define SUPERTWEET_PASSWORD "YourPassword"

#if 1
/*
 * Use "DHCP"
 */
EthernetNetIf eth;
#else
/*
 * Use "static IP address"
 *
 * -> IP
 * -> Subnet mask
 * -> Gateway
 * -> DNS
 */
EthernetNetIf eth(
    IpAddr(xxx,xxx,xxx,xxx),
    IpAddr(xxx,xxx,xxx,xxx),
    IpAddr(xxx,xxx,xxx,xxx),
    IpAddr(xxx,xxx,xxx,xxx));
#endif
TextLCD lcd(p24, p25, p26, p27, p28, p29, p30);
SDFileSystem sd(p5, p6, p7, p8, "sd");
BusOut led(LED4, LED3, LED2, LED1);
SensorMCP9700 sensor1(p20);
SensorMCP9700 sensor2(p19);

void splash(void);
void getDateTime(char *buf, int siz);
int main(void);

/**
 * Display a splash screen.
 */
void splash(void) {
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("StarBoard Orange");
    lcd.locate(0, 1);
    lcd.printf("mbed NXP LPC1768");
    wait(3);

    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("Example app No.1");
    lcd.locate(0, 1);
    lcd.printf("with GoogleChart");
    wait(3);
}

/**
 * Set current date and time.
 *
 * @param year Year.
 * @param month Month.
 * @param day Day.
 * @param hour Hour.
 * @param min Minutes.
 * @param sec Seconds.
 */
void setDateTime(int year, int month, int day, int hour, int min, int sec) {
    struct tm t;
    t.tm_sec = sec;
    t.tm_min = min;
    t.tm_hour = hour;
    t.tm_mday = day;
    t.tm_mon = month - 1;
    t.tm_year = year - 1900;
    time_t seconds = mktime(&t);
    set_time(seconds);
}

/**
 * Get current date and time.
 *
 * @param buf Pointer to buffer.
 * @param siz Size of buffer.
 */
void getDateTime(char *buf, int siz) {
    time_t seconds = time(NULL);
    struct tm *t = localtime(&seconds);
    strftime(buf, siz, "%b/%d/%Y %H:%M:%S", t);
}

/**
 * Entry point.
 */
int main(void) {

    /*
     * Splash.
     */
    splash();

    /*
     * Initialize ethernet interface.
     */
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("Initializing.   ");
    lcd.locate(0, 1);
    lcd.printf("Ethernet:       ");

    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        lcd.locate(0, 1);
        lcd.printf("Ethernet:NG     ");
    } else {
        lcd.locate(0, 1);
        lcd.printf("Ethernet:OK     ");
    }
    wait(3);

    /*
     * Check your SD card.
     */
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("Checking SD card");
    lcd.locate(0, 1);
    lcd.printf("SD card:        ");
    wait(1);
    FILE *fp = fopen("/sd/log_test.txt", "w");
    if (NULL != fp) {
        fprintf(fp, "This is a test file for SD card.");
        fclose(fp);
        lcd.locate(0, 1);
        lcd.printf("SD card:OK      ");
    } else {
        lcd.locate(0, 1);
        lcd.printf("SD card:NG      ");
    }
    wait(1);

    /*
     * Setup http client object.
     *
     * Please replace this information by your account.
     */
    HTTPClient twitter;
    twitter.basicAuth(SUPERTWEET_ACCOUNT, SUPERTWEET_PASSWORD);

    /*
     * Setup GoogleChart objects.
     */
    static const int SAMPLES = 60;
    static const int INTERVAL = 1;

    GoogleChartLineChart chart;
    const int axs1 = chart.addNewAxis(Axis::Left);
    const int axs2 = chart.addNewAxis(Axis::Bottom);
    const int dsn1 = chart.addNewDataSet("Ch.1", SAMPLES);
    const int dsn2 = chart.addNewDataSet("Ch.2", SAMPLES);

    static const int TEMP_HIGH = 50;
    static const int TEMP_LOW = -10;

    chart.setAxisRange(axs1, TEMP_LOW, TEMP_HIGH);
    chart.setAxisRange(axs2, 0, SAMPLES);
    chart.setDataScale(dsn1, TEMP_LOW, TEMP_HIGH);
    chart.setDataScale(dsn2, TEMP_LOW, TEMP_HIGH);

    /*
     * Set date and time. (If you want.)
     *
     * -> Year.
     * -> Month.
     * -> Day.
     * -> Hour.
     * -> Minutes.
     * -> Seconds.
     */
#if 0
    setDateTime(2012, 1, 1, 0, 0, 0);
#endif

    /*
     * Start logging.
     */
    uint16_t count = 0;
    static const int WAIT_FOR_USER = 1;
    while (1) {
        /*
         * Get date and time
         */
        if (0 == (count % SAMPLES)) {
            char dt[64];
            getDateTime(dt, sizeof(dt));
            chart.setTitle(std::string(dt));
        }
        count++;

        /*
         * Status on LED.
         */
        led = count & 0x0f;

        /*
         * Logging current status.
         */
        double sample1 = sensor1.read();
        double sample2 = sensor2.read();
        chart.addData(dsn1, sample1);
        chart.addData(dsn2, sample2);

        /*
         * Display the information.
         */
        lcd.cls();
        lcd.locate(0, 0);
        lcd.printf("Data=[%4.1f,%4.1f]", sample1, sample2);
        lcd.locate(0, 1);
        lcd.printf("Stat=[%4d/%4d]", count, SAMPLES);

        /*
         * Write to storages if the data filled the chart.
         */
        if (0 == (count % SAMPLES)) {
            /*
             * Write to a SD card.
             */
            static int fcnt = 0;
            fcnt++;
            char fname[64];
            snprintf(fname, sizeof(fname), "/sd/log%05d.txt", fcnt);
            lcd.locate(0, 1);
            lcd.printf("SD card:        ");
            FILE *fp = fopen(fname, "w");
            if (NULL != fp) {
                fprintf(fp, "%s\n", chart.toString().c_str());
                fclose(fp);
                lcd.locate(0, 1);
                lcd.printf("SD card:OK      ");
            } else {
                lcd.locate(0, 1);
                lcd.printf("SD card:NG      ");
            }
            wait(WAIT_FOR_USER);

            /*
             * Write to twitter.
             */
            lcd.locate(0, 1);
            lcd.printf("Tweet:          ");
            HTTPMap msg;
            msg["status"] = chart.toString();
            HTTPResult r = twitter.post("http://api.supertweet.net/1/statuses/update.xml", msg, NULL);
            if (r == HTTP_OK) {
                lcd.locate(0, 1);
                lcd.printf("Tweet:OK        ");
            } else {
                lcd.locate(0, 1);
                lcd.printf("Tweet:NG(%02d)    ", r);
            }
            wait(WAIT_FOR_USER);

            /*
             * Clear the logged data.
             */
            chart.clearAllData(dsn1);
            chart.clearAllData(dsn2);
            count = 0;
        }
        wait(INTERVAL);
    }

    return 0;
}
