
#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "TextLCD_SR4.h"

LocalFileSystem fs_local("local");
TextLCD_SR4 lcd(p29, p30, p28, p27);
EthernetNetIf eth;
HTTPServer svr;

int main() {
    Base::add_rpc_class<AnalogIn>();
    Base::add_rpc_class<AnalogOut>();
    Base::add_rpc_class<DigitalIn>();
    Base::add_rpc_class<DigitalOut>();
    Base::add_rpc_class<DigitalInOut>();
    Base::add_rpc_class<PwmOut>();
    Base::add_rpc_class<Timer>();
    Base::add_rpc_class<BusOut>();
    Base::add_rpc_class<BusIn>();
    Base::add_rpc_class<BusInOut>();
    Base::add_rpc_class<Serial>();

    lcd.cls();
    lcd.printf("Setting up...");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        lcd.cls();
        lcd.printf("Error (%d)", ethErr);
        error("Error %d in setup.\n", ethErr);
        return -1;
    } else {
        IpAddr addr = eth.getIp();
        lcd.cls();
        lcd.printf("Network address");
        lcd.locate(0, 1);
        lcd.printf("%3d.%3d.%3d.%3d", addr[0], addr[1], addr[2], addr[3]);
    }

    FSHandler::mount("/local", "/");  //Mount /local path on web root path
    svr.addHandler<FSHandler>("/");      //Default handler
    svr.addHandler<RPCHandler>("/rpc");
    svr.bind(80);

    while (true) {
        Net::poll();
        wait_ms(1);
    }

    return 0;
}
