/**
 * Test program.
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "mbed.h"
#include "SG12864A.h"

int main() {

    SG12864A lcd(p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18);
#if 0
    lcd.clear();
    lcd.reset();

    {
        static const int pages = 8;
        static const int columns = 64;
        for (int i = 0; i < pages; i++) {
            lcd.setPageAddress(SG12864A::CS1, i);
            lcd.setPageAddress(SG12864A::CS2, i);
            for (int j = 0; j < columns; j++) {
                uint8_t n = 1 << (j % 8);
                lcd.setColumnAddress(SG12864A::CS1, j);
                lcd.setColumnAddress(SG12864A::CS2, j);
                lcd.writeData(SG12864A::CS1, n);
                lcd.writeData(SG12864A::CS2, n);
            }
        }
    }

    uint8_t n = 0;
    while (1) {
        lcd.setDisplayStartLine(SG12864A::CS1, n);
        lcd.setDisplayStartLine(SG12864A::CS2, n);
        n++;
        wait_ms(100);
    }
#else
    lcd.clear();
    lcd.reset();
    bool reverse = false;
    while (1) {
        //
        lcd.bufferClear(reverse);
        lcd.bufferDrawLine(0, 0, SG12864A::PIXEL_X - 1, SG12864A::PIXEL_Y - 1, reverse);
        lcd.bufferDrawLine(0, SG12864A::PIXEL_Y - 1, SG12864A::PIXEL_X - 1, 0, reverse);
        lcd.bufferDrawString(1, 1, "This is a test #1.\b", reverse);
        lcd.bufferDrawCheckbox(50, 50, 60, 60, true, reverse);
        lcd.bufferPush();
        wait_ms(1000);

        //
        lcd.bufferClear(reverse);
        lcd.bufferDrawBox(0, 0, SG12864A::PIXEL_X - 1, SG12864A::PIXEL_Y - 1, reverse);
        lcd.bufferDrawString(1, 2, "This is a test #2.\b", reverse);
        lcd.bufferDrawCheckbox(50, 50, 60, 60, false, reverse);
        lcd.bufferPush();
        wait_ms(1000);

#if 0
        //
        lcd.bufferClear(reverse);
        lcd.bufferFillBox(0, 0, SG12864A::PIXEL_X - 1, SG12864A::PIXEL_Y - 1, reverse);
        lcd.bufferDrawString(1, 3, "This is a test #3.\b", reverse);
        lcd.bufferDrawCheckbox(50, 50, 60, 60, true, reverse);
        lcd.bufferPush();
        wait_ms(1000);
#endif

        //
        {
            lcd.bufferClear(reverse);
            int min = 0;
            int max = 100;
            for (int i = min; i <= max; i++) {
                lcd.bufferDrawProgressbar(10, 10, 118, 20, min, max, i, reverse);
                lcd.bufferPush();
                wait_ms(2);
            }
        }

        //
        {
            lcd.bufferClear(reverse);
            int min = -100;
            int max = 100;
            for (int i = min; i <= max; i++) {
                lcd.bufferDrawProgressbar(10, 10, 118, 20, min, max, i, reverse);
                lcd.bufferPush();
                wait_ms(2);
            }
        }

        //
        {
            lcd.bufferClear(reverse);
            int min = 100;
            int max = 600;
            for (int i = min; i <= max; i++) {
                lcd.bufferDrawProgressbar(10, 10, 118, 20, min, max, i, reverse);
                lcd.bufferPush();
                wait_ms(2);
            }
        }

        //
        reverse = !reverse;
    }
#endif
}
