/**
 * Please see related documents.
 *
 * http://shinta-main-jp.blogspot.com/2010/11/linksprite-jpeg-color-camera-ls-y201.html
 * http://shinta-main-jp.blogspot.com/2010/11/mbedlinksprite-jpeg-color-camera-ls.html
 */

#include "mbed.h"

I2C i2c(p9, p10);   // SDA, SCL

char romdat[2048] = {
    0xAA, 0x55, 0x01, 0x00, 0x04, 0xE1, 0x00, 0x01,
    0x2A, 0xF2, 0x02, 0x98, 0x00, 0x0E, 0x00, 0x0D,
    0x02, 0x02, 0x00, 0x00, 0x00, 0x01, 0x1E, 0x08,
    0x01, 0x11, 0x35, 0x02, 0x00, 0x02, 0x21, 0x13,
    0x83, 0x33, 0xB8, 0x0A, 0x10, 0x31, 0x05, 0x08,
    0x00, 0x00, 0x00, 0x64, 0x00, 0x03, 0xE8, 0x07,
    0x00, 0x00, 0x80, 0x00, 0x35, 0x00, 0x5F, 0x00,
    0x00, 0x00, 0x9F, 0x02, 0xE3, 0x02, 0xFA, 0x00,
    0x00, 0x03, 0xB6, 0x03, 0xD2, 0x04, 0x78, 0x04,
    0x84, 0x00, 0x00, 0x00, 0x00, 0x04, 0xA9, 0x04,
    0xB1, 0x04, 0xBF, 0x00, 0x00, 0x04, 0xA4, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xBA, 0x01, 0x02, 0x01, 0x01, 0x00, 0x44, 0x80,
    0x04, 0x05, 0x20, 0x00, 0x00, 0x01, 0x01, 0x08,
    0x01, 0x90, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x82, 0x43, 0x01, 0x00, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x50, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
    0x41, 0x0F, 0x70, 0x11, 0x00, 0x04, 0x00, 0x60,
    0x01, 0x0A, 0x20, 0x1C, 0x10, 0x0A, 0x0A, 0x08,
    0x06, 0x06, 0x04, 0x04, 0x40, 0x80, 0x00, 0xC0,
    0x00, 0x00, 0x60, 0x00, 0x60, 0x78, 0x00, 0x00,
    0x00, 0x97, 0x00, 0x00, 0x00, 0x97, 0x02, 0x02,
    0x0A, 0x05, 0x00, 0x00, 0x00, 0x97, 0x00, 0x7E,
    0x3A, 0xFC, 0x3B, 0x10, 0x00, 0x00, 0x03, 0x64,
    0x01, 0xB4, 0x0C, 0x37, 0x00, 0x64, 0x01, 0x00,
    0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x00, 0x00,
    0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00,
    0x1C, 0x00, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
    0x82, 0x00, 0x00, 0x00, 0x82, 0x0C, 0x77, 0x0C,
    0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20,
    0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20,
    0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20,
    0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20,
    0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x24,
    0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x2C,
    0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x34,
    0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x3C,
    0x00, 0x00, 0x00, 0xA0, 0x00, 0x00, 0x00, 0xA2,
    0x00, 0x00, 0x00, 0xA4, 0x00, 0x00, 0x00, 0xA6,
    0x00, 0x00, 0x00, 0xA8, 0x00, 0x00, 0x00, 0xAA,
    0x00, 0x00, 0x00, 0xAC, 0x00, 0x00, 0x00, 0xAE,
    0x00, 0x00, 0x00, 0xB0, 0x00, 0x00, 0x00, 0xB2,
    0x00, 0x00, 0x00, 0xB4, 0x00, 0x00, 0x00, 0xB6,
    0x00, 0x00, 0x00, 0xB8, 0x00, 0x00, 0x00, 0xBA,
    0x00, 0x00, 0x00, 0xBC, 0x00, 0x00, 0x00, 0xBE,
    0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0xC2,
    0x00, 0x00, 0x00, 0xC4, 0x00, 0x00, 0x00, 0xC6,
    0x00, 0x00, 0x00, 0xC8, 0x00, 0x00, 0x00, 0xCA,
    0x00, 0x00, 0x00, 0xCC, 0x00, 0x00, 0x00, 0xCE,
    0x00, 0x00, 0x00, 0xD0, 0x00, 0x00, 0x00, 0xD2,
    0x00, 0x00, 0x00, 0xD4, 0x00, 0x00, 0x00, 0xD6,
    0x00, 0x00, 0x00, 0xD8, 0x00, 0x00, 0x00, 0xDA,
    0x00, 0x00, 0x00, 0xDC, 0x00, 0x00, 0x00, 0xDE,
    0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xE2,
    0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0xE6,
    0x00, 0x00, 0x00, 0xE8, 0x00, 0x00, 0x00, 0xEA,
    0x00, 0x00, 0x00, 0xEC, 0x00, 0x00, 0x00, 0xEE,
    0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xF2,
    0x00, 0x00, 0x00, 0xF4, 0x00, 0x00, 0x00, 0xF6,
    0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0xFA,
    0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0xFE,
    0x00, 0x00, 0x01, 0xC0, 0x00, 0x00, 0x01, 0xC1,
    0x00, 0x00, 0x01, 0xC2, 0x00, 0x00, 0x01, 0xC3,
    0x00, 0x00, 0x01, 0xC4, 0x00, 0x00, 0x01, 0xC5,
    0x00, 0x00, 0x01, 0xC6, 0x00, 0x00, 0x01, 0xC7,
    0x00, 0x00, 0x01, 0xC8, 0x00, 0x00, 0x01, 0xC9,
    0x00, 0x00, 0x01, 0xCA, 0x00, 0x00, 0x01, 0xCB,
    0x00, 0x00, 0x01, 0xCC, 0x00, 0x00, 0x01, 0xCD,
    0x00, 0x00, 0x01, 0xCE, 0x00, 0x00, 0x01, 0xCF,
    0x00, 0x00, 0x01, 0xD0, 0x00, 0x00, 0x01, 0xD1,
    0x00, 0x00, 0x01, 0xD2, 0x00, 0x00, 0x01, 0xD3,
    0x00, 0x00, 0x01, 0xD4, 0x00, 0x00, 0x01, 0xD5,
    0x00, 0x00, 0x01, 0xD6, 0x00, 0x00, 0x01, 0xD7,
    0x00, 0x00, 0x01, 0xD8, 0x00, 0x00, 0x01, 0xD9,
    0x00, 0x00, 0x01, 0xDA, 0x00, 0x00, 0x01, 0xDB,
    0x00, 0x00, 0x01, 0xDC, 0x00, 0x00, 0x01, 0xDD,
    0x00, 0x00, 0x01, 0xDE, 0x00, 0x00, 0x01, 0xDF,
    0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x01, 0xE1,
    0x00, 0x00, 0x01, 0xE2, 0x00, 0x00, 0x01, 0xE3,
    0x00, 0x00, 0x01, 0xE4, 0x00, 0x00, 0x01, 0xE5,
    0x00, 0x00, 0x01, 0xE6, 0x00, 0x00, 0x01, 0xE7,
    0x00, 0x00, 0x01, 0xE8, 0x00, 0x00, 0x01, 0xE9,
    0x00, 0x00, 0x01, 0xEA, 0x00, 0x00, 0x01, 0xEB,
    0x00, 0x00, 0x01, 0xEC, 0x00, 0x00, 0x01, 0xED,
    0x00, 0x00, 0x01, 0xEE, 0x00, 0x00, 0x01, 0xEF,
    0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, 0x01, 0xF1,
    0x00, 0x00, 0x01, 0xF2, 0x00, 0x00, 0x01, 0xF3,
    0x00, 0x00, 0x01, 0xF4, 0x00, 0x00, 0x01, 0xF5,
    0x00, 0x00, 0x01, 0xF6, 0x00, 0x00, 0x01, 0xF7,
    0x00, 0x35, 0x01, 0x00, 0x15, 0x01, 0x01, 0x00,
    0x00, 0x00, 0x0F, 0x01, 0x04, 0x02, 0x0C, 0xE0,
    0x05, 0x0D, 0x03, 0x7C, 0x30, 0xC0, 0x09, 0x31,
    0x0C, 0x01, 0x00, 0xBC, 0x01, 0x01, 0x00, 0x06,
    0x00, 0xB4, 0x14, 0x0A, 0x04, 0x14, 0x0A, 0x05,
    0x08, 0x03, 0x0A, 0x08, 0x04, 0x05, 0x08, 0x42,
    0xE0, 0x08, 0x43, 0x01, 0x01, 0x01, 0x31, 0x00,
    0x00, 0x01, 0x01, 0x06, 0x00, 0x82, 0x01, 0x01,
    0x35, 0x00, 0x30, 0x18, 0x40, 0x1B, 0x18, 0x42,
    0xDE, 0x18, 0x43, 0x00, 0x18, 0x44, 0x1D, 0x18,
    0x46, 0xDD, 0x18, 0x47, 0x00, 0x18, 0x48, 0x1B,
    0x18, 0x4A, 0xE2, 0x18, 0x4B, 0x00, 0x18, 0x4C,
    0x1D, 0x18, 0x4E, 0x1B, 0x18, 0x50, 0x1C, 0x18,
    0x5A, 0x14, 0x18, 0x5C, 0x13, 0x18, 0x5E, 0x14,
    0x19, 0x0F, 0x0C, 0x19, 0x94, 0x50, 0x19, 0x95,
    0x05, 0x19, 0x97, 0x13, 0x19, 0x99, 0xFF, 0x19,
    0x9A, 0x03, 0x19, 0x9B, 0x05, 0x19, 0x9C, 0x0A,
    0x19, 0x9D, 0x0E, 0x19, 0x80, 0x08, 0x19, 0x82,
    0x12, 0x19, 0x84, 0x38, 0x19, 0x85, 0x40, 0x19,
    0x8D, 0xFF, 0x19, 0x8E, 0x23, 0x19, 0x89, 0xFF,
    0x19, 0x8A, 0x24, 0x19, 0x8F, 0x2E, 0x1A, 0x15,
    0x48, 0x1B, 0x19, 0x20, 0x1B, 0x1A, 0x80, 0x1B,
    0x1B, 0x20, 0x1B, 0x1C, 0x80, 0x1B, 0x22, 0x06,
    0x1B, 0x23, 0x0A, 0x1B, 0x28, 0x31, 0x1B, 0x29,
    0x13, 0x1B, 0x2A, 0x42, 0x1B, 0x2B, 0x24, 0x1B,
    0x2C, 0x42, 0x1B, 0x2D, 0x24, 0x1B, 0x2E, 0x31,
    0x1B, 0x2F, 0x13, 0x08, 0x01, 0x41, 0x00, 0xF5,
    0x00, 0x02, 0x00, 0x00, 0x04, 0x03, 0x02, 0x08,
    0x07, 0x05, 0x06, 0x09, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x18, 0x10, 0x10, 0x00, 0x40,
    0x00, 0x30, 0x00, 0xA4, 0x03, 0x40, 0x00, 0x03,
    0x30, 0x00, 0x03, 0x24, 0xFF, 0xFF, 0xFF, 0xFF,
    0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0xA0, 0x00,
    0x40, 0x01, 0xE0, 0x01, 0x7F, 0x02, 0x00, 0x00,
    0x78, 0x00, 0xF0, 0x00, 0x68, 0x01, 0xDF, 0x01,
    0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04,
    0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04,
    0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04,
    0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04,
    0x00, 0x1E, 0x00, 0x1E, 0x00, 0x1E, 0x00, 0x1E,
    0x00, 0x1E, 0x00, 0x1E, 0x00, 0x1E, 0x00, 0x1E,
    0x00, 0x1E, 0x00, 0x1E, 0x00, 0x1E, 0x00, 0x1E,
    0x00, 0x1E, 0x00, 0x1E, 0x00, 0x1E, 0x00, 0x1E,
    0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06,
    0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06,
    0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06,
    0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06,
    0x00, 0x2D, 0x00, 0x2D, 0x00, 0x2D, 0x00, 0x2D,
    0x00, 0x2D, 0x00, 0x2D, 0x00, 0x2D, 0x00, 0x2D,
    0x00, 0x2D, 0x00, 0x2D, 0x00, 0x2D, 0x00, 0x2D,
    0x00, 0x2D, 0x00, 0x2D, 0x00, 0x2D, 0x00, 0x2D,
    0x50, 0xF8, 0xF8, 0xF8, 0x50, 0xF8, 0xF8, 0xF8,
    0x50, 0x00, 0x00, 0x00, 0x10, 0x20, 0x30, 0x40,
    0x50, 0x60, 0x70, 0x80, 0x90, 0xA0, 0xB0, 0xC0,
    0xD0, 0xE0, 0xF0, 0x00, 0x28, 0x46, 0x60, 0x71,
    0x81, 0x90, 0x9D, 0xAA, 0xB6, 0xC2, 0xCD, 0xD8,
    0xE3, 0xED, 0xF6, 0xFF, 0x00, 0x80, 0x80, 0x00,
    0x40, 0x11, 0x08, 0x08, 0x06, 0x17, 0x08, 0x08,
    0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x81,
    0x00, 0x81, 0x81, 0x00, 0x08, 0x10, 0x18, 0x05,
    0x0F, 0x7F, 0x7F, 0x08, 0x00, 0x20, 0x33, 0x33,
    0x33, 0x33, 0x03, 0x1E, 0x7B, 0x09, 0x01, 0x58,
    0x60, 0x00, 0x00, 0x03, 0xFF, 0x10, 0x10, 0x18,
    0x18, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
};

/**
 * Write to a ROM.
 *
 * @return Return 0 if it succeed.
 */
int eeprom_24lc16b_write() {
    char data[2];

    for (int i = 0; i < (8 * 256); i++) {
        int c = romdat[i];
        printf("%d/%d (%02x)\n", i + 1, (8 * 256), c);
        int addr = 0xA0 | ((i / 256) << 1);
        data[0] = i % 256;  // Word address
        data[1] = c;  // Data
        if (i2c.write(addr, data, 2)) {
            return -3;
        }
        wait_ms(10);
    }
    return 0;
}

int main() {

    wait(1);
    printf("Writing...\n");

    i2c.frequency(10000);
    int r = eeprom_24lc16b_write();
    if (r != 0) {
        printf("Fail. (code=%d)\n", r);
    } else {
        printf("Done.\n");
    }
}
