/**
 * Performance problems with HTTPText.
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

static const int ClientTimeoutMs = 1000;

EthernetNetIf netif;
Timer timer;

void test(int bufsiz);
int main(void);

/**
 * Execute the test.
 *
 * @param bufsiz Buffer size of a HTTPText.
 */
void test(int bufsiz) {
    HTTPClient client;
    HTTPMap map;
    HTTPText text("text/html", bufsiz);

    client.setTimeout(ClientTimeoutMs);

    int sizelist[10] = {
        8,
        16,
        32,
        64,
        128,
        256,
        512,
        1024,
        2048,
        4096
    };

    printf("(Buffer size of a HTTPText : %d)\n", bufsiz);
    printf("+---------+--------+------+--------+\n");
    printf("|File size|Time[ms]|Result|Response|\n");
    printf("+---------+--------+------+--------+\n");
    for (int i = 0; i < sizeof(sizelist) / sizeof(sizelist[0]); i++) {
        char url[256];
        sprintf(url, "http://mbed.org/media/uploads/shintamainjp/textfile_%dbytes.txt", sizelist[i]);
        timer.stop();
        timer.reset();
        timer.start();
        HTTPResult r = client.get(url, &text);
        timer.stop();
        printf("|%9d|%8d|%6d|%8d|\n", sizelist[i], timer.read_ms(), (int)r, client.getHTTPResponseCode());
    }
    printf("+---------+--------+------+--------+\n");
}

/**
 * Entry point.
 */
int main(void) {
    int bufsizlist[10] = {
        8,
        16,
        32,
        64,
        128,
        256,
        512,
        1024,
        2048,
        4096
    };

    EthernetErr ethErr = netif.setup();
    if (ethErr) {
        error("Network setup failed.\n");
    }

    for (int i = 0; i < sizeof(bufsizlist) / sizeof(bufsizlist[0]); i++) {
        printf("\n");
        test(bufsizlist[i]);
    }
}
