/**
 * A test program for Pachube API interface driver. (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "mbed.h"
#include "PachubeV2CSV.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "ThermistorMCP9701.h"

#define API_KEY "YourAPIKey"
#define FEED_ID 99999
#define STREAM_ID "YourStreamID"

PachubeV2CSV web(API_KEY);
EthernetNetIf eth;
ThermistorMCP9701 thermistor1(p16);

/**
 * Example No.1
 */
void example1(void) {
    int page = 1;
    int per_page = 10;
    std::string content = "";
    std::string q = "";
    std::string tag = "";
    std::string user = "";
    std::string units = "";
    std::string status = "";
    std::string order = "";
    std::string datatext = "";
    web.listAllAvailableFeeds(
        page,
        per_page,
        content,
        q,
        tag,
        user,
        units,
        status,
        order,
        datatext);
    printf("====Data====\n%s\n============\n", datatext.c_str());
}

/**
 * Example No.2
 */
void example2_loop(void) {
    const int feed_id = FEED_ID;
    const std::string stream_id = STREAM_ID;
    
    int cnt = 0;
    while (1) {
        double val1 = thermistor1.read();
        char val1_text[32];
        sprintf(val1_text, "%f", val1);
        if (cnt == 0) {
            printf("createNewDataStream(%d)\n", web.createNewDataStream(feed_id, stream_id, std::string(val1_text)));
        } else {
            printf("updateDataStream(%d)\n", web.updateDataStream(feed_id, stream_id, std::string(val1_text)));
        }
        cnt++;
        wait(10);
    }
}

/**
 * Entry point.
 */
int main() {
    eth.setup();

    example1();
    example2_loop();
}
