/**
 * Test program.
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "mbed.h"
#include "TextLCD.h"
#include "PS2Mouse.h"
#include "PS2Keyboard.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30);
PS2Keyboard ps2kb(p12, p11);
PS2Mouse ps2ms(p23, p22);

int main() {
    PS2Mouse::mouse_event_t evt_ms;
    PS2Keyboard::keyboard_event_t evt_kb;

    lcd.locate(0, 0);
    lcd.printf("> Mouse        <");
    lcd.locate(0, 1);
    lcd.printf("> Keyboard     <");

    int div = 0;
    while (1) {
        div++;
        if (div % 2) {
            if (ps2ms.processing(&evt_ms)) {
                lcd.locate(0, 0);
                lcd.printf("%c%c%c:%4d,%4d,%2d",
                           evt_ms.left ? 'L' : '.',
                           evt_ms.center ? 'C' : '.',
                           evt_ms.right ? 'R' : '.',
                           evt_ms.x, evt_ms.y, evt_ms.z);
            }
        } else {
            if (ps2kb.processing(&evt_kb)) {
                lcd.locate(0, 1);
                for (int i = 0; i < evt_kb.length; i++) {
                    lcd.printf("%02X", evt_kb.scancode[i]);
                }
                for (int i = 0; i < 16 - evt_kb.length * 2; i++) {
                    lcd.printf("-");
                }
            }
        }
    }
}
