#include "mbed.h"
#include "microshell.h"
#include "msconf.h"

Serial pc(USBTX, USBRX);

static void utx(char c)
{
    pc.putc(c);
}

static char urx(void)
{
    return pc.getc();
}

static void action_hook(MSCORE_ACTION action)
{
}

int main(void)
{
    char buf[MSCONF_MAX_INPUT_LENGTH];
    MICROSHELL ms;

    puts(
            "\r\n\r\n"
            "======================================\r\n"
            " MicroShell Simple Example for LPC824 \r\n"
            "======================================\r\n"
            );
    puts(" Type 'help' for a list of commands.\r\n");

    microshell_init(&ms, utx, urx, action_hook);

    while (1) {
        puts("MicroShell>");
        microshell_getline(&ms, buf, sizeof(buf));
    }

    return 0;
}