/**
 * GoogleChart API interface driver. (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#ifndef _GOOGLE_CHART_H_
#define _GOOGLE_CHART_H_

#include <string.h>
#include <string>
#include <ctype.h>

#include <mbed.h>

#include "Axis.h"
#include "DataSet.h"

class GoogleChart {
public:

    GoogleChart();
    virtual ~GoogleChart();

    virtual std::string toString() = 0;

    int addNewAxis(Axis::Type type = Axis::Bottom);
    int setAxisType(const int number, Axis::Type type);
    int setAxisRange(const int number, int rangeStart, int rangeEnd);
    int removeAxis(const int number);
    
    int addNewDataSet(std::string label, const int size);
    int removeDataSet(const int number);
    int addData(const int number, double data);
    int clearAllData(const int number);
    int setDataScale(const int number, int min, int max);

    void setTitle(std::string title);
    std::string getTitle() const;
    void setWidth(int width);
    int getWidth() const;
    void setHeight(int height);
    int getHeight() const;

protected:
    static const std::string baseURL;
    std::string title;
    int width;
    int height;
    
    static const int MAX_AXIS = 16;
    Axis *axislist[MAX_AXIS];
    
    static const int MAX_DATA = 16;
    DataSet *datalist[MAX_DATA];

    typedef enum {
        LineChart
    } ChartType;

    static std::string toURL(std::string text);

    static std::string paramChartType(ChartType chartType);
    static std::string paramAxis(Axis **list, int size);
    static std::string paramDataSet(DataSet **list, int size);
    static std::string paramTitle(std::string title, int color, double fontSize);
    static std::string paramSize(int width, int height);
};

#endif
