/**
 * GoogleChart API interface driver. (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#ifndef _DATA_SET_H_
#define _DATA_SET_H_

#include <string>

class DataSet {
public:
    typedef enum {
        Simple,
        Extended,
        Text
    } EncodeType;
    
    DataSet(std::string label, int number, int size, EncodeType encodeType = Text);
    ~DataSet();
    
    std::string getLabel();
    int getNumber();
    int getSize();
    void setEncodeType(EncodeType encodeType);
    EncodeType getEncodeType();
    
    void clearAllData();
    void addData(double data);
    int getDataCount();
    double getData(int index);
    
    void setScale(double min, double max) {
        DataSet::min = min;
        DataSet::max = max;
    }
    double getMin() { return min; }
    double getMax() { return max; }
    
private:

    const std::string label;
    const int number;
    const int size;
    EncodeType encodeType;
    double *datalist;
    int dataCount;
    double min;
    double max;
};

#endif
