/**
 * =============================================================================
 * A test program for firmware updater (Version 0.0.2)
 * http://mbed.org/users/shintamainjp/notebook/firmwareupdater_en/
 * =============================================================================
 * Copyright (c) 2010 Shinichiro Nakamura (CuBeatSystems)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * =============================================================================
 */

#include "mbed.h"
#include "FirmwareUpdater.h"
#include "EthernetNetIf.h"

#define APPLICATION_NAME "firm"
#define SERVER_VERSION 0

EthernetNetIf eth;
FirmwareUpdater fwup("http://mbed.org/media/uploads/shintamainjp/", APPLICATION_NAME, true);
BusOut led(LED4, LED3, LED2, LED1);
Ticker ticker;

// [On a server]
//  1. firm.txt : firmware version file.
//  2. firm.bin : firmware binary file.
//
// [On a mbed]
//  1. firm.txt : firmware version file.
//  2. firm.bin : firmware binary file.

/**
 * LED function Type-1.
 */
void tick_func1() {
    led = led + 1;
}

/**
 * LED function Type-2.
 */
void tick_func2() {
    led = led - 1;
}

/**
 * Entry point.
 */
int main() {
    eth.setup();

#if SERVER_VERSION
    printf("[%s: Server version.]\n", APPLICATION_NAME);
    ticker.attach_us(&tick_func1, 200 * 1000);
#else
    printf("[%s: Local version.]\n", APPLICATION_NAME);
    ticker.attach_us(&tick_func2, 200 * 1000);
#endif

    const int a = fwup.exist();
    if (a == 0) {
        printf("Found a new firmware.\n");
        const int b = fwup.execute();
        if (b == 0) {
            printf("Update succeed.\n");
            printf("Resetting this system...\n\n\n\n\n");
            fwup.reset();
        } else {
            printf("Failed execute() [Code=%d]\n", b);
        }
    } else {
        if (a < 0) {
            printf("Failed exist() [Code=%d]\n", a);
        } else {
            printf("Up to date.\n");
        }
    }
}
