/*
* WiiNunchuckReader. A program allowing the output of one or two
* Wii Nunchucks to be read via I2C and decoded for use, using the mbed
* microcontroller and its associated libraries.
*
* Copyright (C) <2009> Petras Saduikis <petras@petras.co.uk>
*
* This file is part of WiiNunchuckReader.
*
* WiiNunchuckReader is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* WiiNunchuckReader is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with WiiNunchuckReader.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SNATCH59_WIINUNCHUCKDEFS_H
#define SNATCH59_WIINUNCHUCKDEFS_H

// I2C
#define NUNCHUCK_ADDR     0xA4  // I2C library doesn't right shift the address, so provided shifted
#define NUNCHUCK_REGADDR  0x40  // relevant register address
#define NUNCHUCK_READLEN  0x06  // always read this many bytes back

// received byte position
#define JOY_X      0
#define JOY_Y      1
#define ACCEL_X    2
#define ACCEL_Y    3
#define ACCEL_Z    4
#define ADDITIONAL 5

// bitmasks for addition info byte
#define MASK_CZ      0x03
#define MASK_ACCLX1  0x04
#define MASK_ACCLX2  0x08
#define MASK_ACCLY1  0x10
#define MASK_ACCLY2  0x20
#define MASK_ACCLZ1  0x40
#define MASK_ACCLZ2  0x80

// timing
#define I2C_READ_DELAY  0.01

// I2C status
#define I2C_OK        0    // zero on success (ACK), non-zero on fail (NACK) for read or write

#endif