/*
* WiiNunchuckReader. A program allowing the output of one or two
* Wii Nunchucks to be read via I2C and decoded for use, using the mbed
* microcontroller and its associated libraries.
*
* Copyright (C) <2009> Petras Saduikis <petras@petras.co.uk>
*
* This file is part of WiiNunchuckReader.
*
* WiiNunchuckReader is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* WiiNunchuckReader is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with WiiNunchuckReader.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SNATCH59_WIINUNCHUCKREADER_H
#define SNATCH59_WIINUNCHUCKREADER_H

#include <mbed.h>
#include "WiiNunchuckDefs.h"

typedef unsigned char BYTE;

class WiiNunchuckReader {
public:
    // constructors
    WiiNunchuckReader(PinName sda, PinName scl);

    // functions
    void RequestRead();

    // accessors
    int getJoyX() const {
        return joyX;
    }
    int getJoyY() const {
        return joyY;
    }
    int getAccelX() const {
        return accelX;
    }
    int getAccelY() const {
        return accelY;
    }
    int getAccelZ() const {
        return accelZ;
    }
    int getButtonC() const {
        return buttonC;
    }
    int getButtonZ() const {
        return buttonZ;
    }
    int getBufferSize() const {
        return sizeof(readBuf);
    }
    char* getReadBuf() {
        return readBuf;
    }

private:
    // nunchuck controls states
    int joyX;
    int joyY;
    int accelX;
    int accelY;
    int accelZ;
    int buttonC;
    int buttonZ;

    // nunchuck init state
    bool nunchuckInit;

    // nunchuck I2C port
    I2C nunchuckPort;

    // read data
    char readBuf[NUNCHUCK_READLEN];

    // functions
    bool NunchuckInit();
    bool NunchuckRead();
    void NunchuckDecode();
    void DecodeAdditional();
};

#endif