#include "appconf.h"
#include <ConfigFile.h>

LocalFileSystem fs_local("local");

/*
 * Configuration File Example.
 *
 * Ch1=A
 * Ch2=B
 */

#define CONFIG_FILENAME "/local/SETUP.CFG"

#define KEY_CH1 "Ch1"
#define KEY_CH2 "Ch2"
#define VALUE_CHANNEL_A "A"
#define VALUE_CHANNEL_B "B"
#define VALUE_CHANNEL_C "C"
#define VALUE_CHANNEL_D "D"

/**
 * Initialize a configuration.
 *
 * @param p A pointer to a configuration structure.
 */
void appconf_init(appconf_t *p) {
    p->ch1 = ChoroQ::ChA;
    p->ch2 = ChoroQ::ChB;
}

/**
 * Get a channel from the key.
 *
 * @param cf A pointer to a config file object.
 * @param p A pointer to a application config.
 * @param key The key.
 * @param ch A pointer to the channel.
 *
 * @return Return 0 if it succeed.
 */
static int getChannel(ConfigFile *cf, appconf_t *p, char *key, ChoroQ::Channel *ch) {
    char value[64];
    if (!cf->getValue(key, value, sizeof(value))) {
        return -1;
    }

    if (strcmp(value, VALUE_CHANNEL_A) == 0) {
        *ch = ChoroQ::ChA;
        return 0;
    } else if (strcmp(value, VALUE_CHANNEL_B) == 0) {
        *ch = ChoroQ::ChB;
        return 0;
    } else if (strcmp(value, VALUE_CHANNEL_C) == 0) {
        *ch = ChoroQ::ChC;
        return 0;
    } else if (strcmp(value, VALUE_CHANNEL_D) == 0) {
        *ch = ChoroQ::ChD;
        return 0;
    } else {
        return -2;
    }
}

/**
 * Read a configuration.
 *
 * @param p A pointer to a configuration structure.
 *
 * @return Return 0 if read succeed.
 */
int appconf_read(appconf_t *p) {
    ConfigFile cfg;

    if (!cfg.read(CONFIG_FILENAME)) {
        return -1;
    }

    if (getChannel(&cfg, p, KEY_CH1, &p->ch1) != 0) {
        return -2;
    }
    if (getChannel(&cfg, p, KEY_CH2, &p->ch2) != 0) {
        return -3;
    }

    return 0;
}
