/**
 * CHORO Q HYBRID control class (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */
#ifndef _CHORO_Q_H_
#define _CHORO_Q_H_

#include <mbed.h>
#include <inttypes.h>
#include <TransmitterChoroQ.h>

/**
 * CHORO Q HYBRID control class.
 */
class ChoroQ {
public:

    /**
     * Control channel.
     */
    typedef enum {
        ChA,
        ChB,
        ChC,
        ChD
    } Channel;

    /**
     * Create.
     *
     * @param pin A pin of IR.
     */
    explicit ChoroQ(PinName pin);

    /**
     * Destroy.
     */
    ~ChoroQ();

    /**
     * Action.
     */
    typedef enum {
        Undef,
        Up,
        Down,
        Left,
        Right,
        UpDash,
        UpLeft,
        UpRight,
        UpRightDash,
        UpLeftDash,
        DownLeft,
        DownRight,
        DownDash,
        DownLeftDash,
        DownRightDash,
        Stop
    } Action;

    /**
     * Execute control.
     *
     * @param ch A control channel.
     * @param action An action.
     * @param interval Keep interval time if this flag is true.
     */
    void execute(Channel ch, Action action, bool keepInterval = true);

private:
    typedef struct {
        Action action;
        char *command;
    } action_t;

    static const int TARGET_ID_CH_A = 0x00;
    static const int TARGET_ID_CH_B = 0x02;
    static const int TARGET_ID_CH_C = 0x01;
    static const int TARGET_ID_CH_D = 0x03;
    static const action_t list[];

    static const int PACKET_INTERVAL_MS = 160;
    static const int REPEAT_INTERVAL_MS_CH_A = 20;
    static const int REPEAT_INTERVAL_MS_CH_B = 40;
    static const int REPEAT_INTERVAL_MS_CH_C = 60;
    static const int REPEAT_INTERVAL_MS_CH_D = 80;

    TransmitterChoroQ irtx;
    Timer timer;

    uint8_t *getCommand(Action action);
};

#endif
