/**
 * CHORO Q HYBRID control class (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */
#include "ChoroQ.h"

const ChoroQ::action_t ChoroQ::list[] = {
    {Undef, "\x00"},
    {Up, "\x20"},
    {Down, "\x10"},
    {Left, "\x30"},
    {Right, "\x08"},
    {UpDash, "\x28"},
    {UpLeft, "\x18"},
    {UpRight, "\x38"},
    {UpLeftDash, "\x04"},
    {UpRightDash, "\x24"},
    {DownLeft, "\x14"},
    {DownRight, "\x34"},
    {DownDash, "\x0C"},
    {DownLeftDash, "\x2C"},
    {DownRightDash, "\x1C"},
    {Stop, "\x3C"}
};

/**
 * Create.
 *
 * @param pin A pin of IR.
 */
ChoroQ::ChoroQ(PinName pin) : irtx(pin) {
}

/**
 * Destroy.
 */
ChoroQ::~ChoroQ() {
}

/**
 * Execute control.
 *
 * @param ch A control channel.
 * @param action An action.
 * @param interval Keep interval time if this flag is true.
 */
void ChoroQ::execute(Channel ch, Action action, bool keepInterval) {
    /*
     * Set the target ID and the interval time for a channel.
     */
    int target_id;
    int interval_time;
    switch (ch) {
        case ChA:
            target_id = TARGET_ID_CH_A;
            interval_time = REPEAT_INTERVAL_MS_CH_A;
            break;
        case ChB:
            target_id = TARGET_ID_CH_B;
            interval_time = REPEAT_INTERVAL_MS_CH_B;
            break;
        case ChC:
            target_id = TARGET_ID_CH_C;
            interval_time = REPEAT_INTERVAL_MS_CH_C;
            break;
        case ChD:
            target_id = TARGET_ID_CH_D;
            interval_time = REPEAT_INTERVAL_MS_CH_D;
            break;
        default:
            // printf("Unknown target channel found.\n");
            return;
    }

    /*
     * Get a command.
     */
    uint8_t *command = getCommand(action);
    if (command != NULL) {
        static const int BITLENGTH_FOR_CHORO_Q = 6;
        uint8_t buf[1];
        buf[0] = command[0] | target_id;

        /*
         * Transmit it.
         */
        timer.stop();
        timer.reset();
        timer.start();
        irtx.setData(buf, BITLENGTH_FOR_CHORO_Q);
        wait_ms(interval_time);
        
        /*
         * I don't need keep a interval time if I use only a CHORO Q.
         * But kids need more CHORO Q cars sometime.
         * A keep interval time is difference by a channel.
         */
        irtx.setData(buf, BITLENGTH_FOR_CHORO_Q);
        if (keepInterval) {
            timer.stop();
            const int ms = timer.read_ms();
            wait_ms(PACKET_INTERVAL_MS - ms);
        } else {
            wait_ms(interval_time);
            timer.stop();
        }
    }
}

uint8_t *ChoroQ::getCommand(Action action) {
    const int n = sizeof(list) / sizeof(list[0]);
    for (int i = 0; i < n; i++) {
        const action_t *p = &list[i];
        if (p->action == action) {
            return (uint8_t *)p->command;
        }
    }
    return NULL;
}
