#include "mbed.h"
#include "AitendoOLED.h"

AitendoOLED oled(p5, p6, p7, p22, p21, p23);

typedef struct rect {
    int w;
    int h;
    int x;
    int y;
    int dx;
    int dy;
    AitendoOLED::Color c;
} rect_t;

int main() {
    const int SCRX = 96;
    const int SCRY = 64;
    const int RECTCNT = 8;
    rect_t rectlist[RECTCNT] = {
        { .w = 10, .h = 10, .x = 0, .y = 0, .dx = 1, .dy = 1, .c.r = 0x80, .c.g = 0x00, .c.b = 0x00 },
                                         { .w = 10, .h = 10, .x = 10, .y = 0, .dx = 1, .dy = 1, .c.r = 0xFF, .c.g = 0x00, .c.b = 0x00 },
                                         { .w = 10, .h = 10, .x = 20, .y = 0, .dx = 1, .dy = 1, .c.r = 0x00, .c.g = 0x80, .c.b = 0x00 },
                                         { .w = 10, .h = 10, .x = 30, .y = 0, .dx = 1, .dy = 1, .c.r = 0x00, .c.g = 0xFF, .c.b = 0x00 },
                                         { .w = 10, .h = 10, .x = 0, .y = 0, .dx = 1, .dy = 1, .c.r = 0x00, .c.g = 0x00, .c.b = 0x80 },
                                         { .w = 10, .h = 10, .x = 0, .y = 10, .dx = 1, .dy = 1, .c.r = 0x00, .c.g = 0x00, .c.b = 0xFF },
                                         { .w = 10, .h = 10, .x = 0, .y = 20, .dx = 1, .dy = 1, .c.r = 0x80, .c.g = 0x80, .c.b = 0x00 },
                                         { .w = 10, .h = 10, .x = 0, .y = 30, .dx = 1, .dy = 1, .c.r = 0xFF, .c.g = 0xFF, .c.b = 0x00 }
                                     };
    AitendoOLED::Color white;
    white.r = 0xff;
    white.g = 0xff;
    white.b = 0xff;
    oled.clear(0, 0, SCRX - 1, SCRY - 1);
    oled.drawLine(0, 0, SCRX -1, SCRY - 1, white);
    oled.drawLine(0, SCRY - 1, SCRX -1, 0, white);
    wait(5);

    while (1) {
        oled.clear(0, 0, SCRX - 1, SCRY - 1);
        for (int i = 0; i < RECTCNT; i++) {
            rect_t *rp = &rectlist[i];
            rp->x += rp->dx;
            rp->y += rp->dy;
            if (SCRX - rp->w <= rp->x) {
                rp->dx = -1;
            }
            if (rp->x <= 0) {
                rp->dx = 1;
            }
            if (SCRY - rp->h <= rp->y) {
                rp->dy = -1;
            }
            if (rp->y <= 0) {
                rp->dy = 1;
            }
            oled.fillBox(rp->x, rp->y, rp->x + rp->w - 1, rp->y + rp->h - 1, rp->c, rp->c);
        }
        wait_ms(10);
    }
}
