 
#include "mlx90615.h"




MLX90615::MLX90615(I2C* i2c,int addr){

    this->i2caddress = addr;
    this->i2c = i2c; 
    
}


bool MLX90615::getTemp(float* temp_val){

    char ch1, ch2;
    char cmd[3];
    
    cmd[0] = 0x27;
    cmd[1] = 0;
    cmd[2] = 0;
    
    i2c->stop();
    wait_us(5);
    ch1 = i2c->write(0xb6, cmd, 1, true);
    if (ch1 != 0) {return false;}
    ch2 = i2c->read(0xb7, cmd, 3);
    if (ch2 != 0) {return false;}
    wait_us(5);
    
    *temp_val = ((((cmd[1]&0x007f)<<8)+cmd[0])*0.02)-273.15;
        return true;

}

bool MLX90615::getTempAmbient(float* temp_val){

    char ch1, ch2;
    char cmd[3];
    
    cmd[0] = 0x26;
    cmd[1] = 0;
    cmd[2] = 0;
    
    i2c->stop();
    wait_us(5);
    ch1 = i2c->write(0xb6, cmd, 1, true);
    if (ch1 != 0) {return false;}
    ch2 = i2c->read(0xb7, cmd, 3);
    if (ch2 != 0) {return false;}
    wait_us(5);
    
    *temp_val = ((((cmd[1]&0x007f)<<8)+cmd[0])*0.02)-273.15;
        return true;

}

bool MLX90615::getRawIR(int16_t* ir_val){

    char ch1, ch2;
    char cmd[3];
    uint16_t temp;
        
    cmd[0] = 0x25;
    cmd[1] = 0;
    cmd[2] = 0;
    
    i2c->stop();
    wait_us(5);
    ch1 = i2c->write(0xb6, cmd, 1, true);
    if (ch1 != 0) {return false;}
    ch2 = i2c->read(0xb7, cmd, 3);
    if (ch2 != 0) {return false;}
    wait_us(5);
    temp = (uint16_t)((cmd[1]<<8)|cmd[0]);
    if(temp & 0x8000) *ir_val = ~((int16_t)(temp & 0x7fff))+1;
    else *ir_val = (int16_t)temp;
    return true;

}