#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include "mlx90615.h"

DigitalOut myled_R(LED1);

I2C i2c_sensor(I2C_SDA,I2C_SCL);
I2C i2c_oled(D12, A6);

Adafruit_SSD1306_I2c myOled(i2c_oled,NC,0x78,64,128);
MLX90615 myMlx(&i2c_sensor);

Serial pc(USBTX, USBRX, 9600);
Serial HC06(D1, D0, 9600);

int main()
{   
    float temp = 0.0;
    float amb_temp = 0.0;
    int16_t ir_data = 0;
    
    myOled.begin();
    myOled.printf("%ux%u \nHellow World\r\n", myOled.width(), myOled.height());
    myOled.display();
    
    myOled.clearDisplay();
    
    pc.printf("===============Hello world===============\n\r");

    while(1)
    {
        myled_R = !myled_R;
        
        temp = 0;
        amb_temp = 0;
        ir_data = 0;

        if (myMlx.getTemp(&temp)& myMlx.getTempAmbient(&amb_temp) & myMlx.getRawIR(&ir_data))
        {
            myOled.clearDisplay();
            myOled.setTextCursor(0,0);
            pc.printf("%5.2f, %5.2f, %d\n",temp, amb_temp, ir_data);
            HC06.printf("%5.2f, %5.2f, %d\r\n",temp, amb_temp, ir_data);
            myOled.printf("%5.2f, %5.2f, %d\r\n",temp, amb_temp, ir_data);
            myOled.display();
        }
        wait(1.0);
        
        
    }
}