#include "mbed.h"
#include "mbed.h"
#include "EthernetInterface.h"

#define ECHO_SERVER_PORT   10373

DigitalOut digitalclock_colon (p17);
DigitalOut digitalclock (p18);
DigitalOut signal_LED_L (p19);
DigitalOut signal_LED_R (p20);

PwmOut meter_LED_outside (p21);
PwmOut meter_LED_inside (p22);
PwmOut needle_LED (p23);
PwmOut Other_range_LED (p24);
PwmOut D_range_LED (p25);
PwmOut P_range_LED (p26);

void meter_LED_outside_flashing1()
{
    meter_LED_outside = 0;
    wait_ms(100);
    meter_LED_outside = 0.1;
    wait_ms(100);
    meter_LED_outside = 0;
    wait_ms(100);
    meter_LED_outside = 0.1;
    wait_ms(100);
    meter_LED_outside = 0;
    wait_ms(100);
    meter_LED_outside = 0.1;
}
void meter_LED_outside_flashing2()
{
    meter_LED_outside = 0;
    wait_ms(100);
    meter_LED_outside = 0.1;
    wait_ms(100);
    meter_LED_outside = 0;
    wait_ms(100);
    meter_LED_outside = 0.1;
    wait_ms(100);
    meter_LED_outside = 0;
    wait_ms(100);
    meter_LED_outside = 0.1;
    wait_ms(100);
    meter_LED_outside = 0;
    wait_ms(100);
    meter_LED_outside = 0.1;
    wait_ms(100);
    meter_LED_outside = 0;
    wait_ms(100);
    meter_LED_outside = 0.1;
}

int main()
{
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());

    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();

    meter_LED_outside.period_ms (1);

    P_range_LED = 0.5;
    wait(0.5);
    P_range_LED = 0.0;
    P_range_LED = 0.5;
    wait(0.5);
    P_range_LED = 0.0;

    while (1) {
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 1500);
        printf("Client connected %s\n", client.get_address());

        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n > 0) {
                int target = (buffer[1] - '0') * 100 + (buffer[2] - '0') * 10 + (buffer[3] - '0');

                if (buffer[0] == 'A') {
                    for(float p = 0.0f; p < 0.8f; p += 0.02f) {
                        meter_LED_outside = p;
                        wait(0.01);
                    }
                    for(float p = 0.0f; p < 0.8f; p += 0.02f) {
                        meter_LED_inside = p;
                        wait(0.01);
                    }
                    for(float p = 0.0f; p < 0.8f; p += 0.02f) {
                        P_range_LED = p;
                        wait(0.01);
                    }
                    for(float p = 0.0f; p < 0.8f; p += 0.02f) {
                        D_range_LED = p;
                        wait(0.01);
                    }
                    for(float p = 0.0f; p < 0.8f; p += 0.02f) {
                        Other_range_LED = p;
                        wait(0.01);
                    }
                    for(float p = 0.0f; p < 0.8f; p += 0.02f) {
                        needle_LED = p;
                        wait(0.01);
                    }
                    for(float p = 1.0f; p > 0.0f; p -= 0.02f) {
                        meter_LED_outside = p;
                        meter_LED_inside = p;
                        P_range_LED = p;
                        D_range_LED = p;
                        Other_range_LED = p;
                        needle_LED = p;
                        wait(0.01);
                    }
                    signal_LED_L = 1;
                    signal_LED_R = 1;
                    wait (0.5);
                    signal_LED_L = 0;
                    signal_LED_R = 0;
                    wait (0.5);
                    signal_LED_L = 1;
                    signal_LED_R = 1;
                    wait (0.5);
                    signal_LED_L = 0;
                    signal_LED_R = 0;
                    needle_LED = (1.0);
                    wait (3.5);

                    for(float p = 0.0f; p < 0.1f; p += 0.01f) {
                        meter_LED_outside = p;
                        meter_LED_inside = p;
                        P_range_LED = p;
                        wait(0.05);
                    }
                    digitalclock = 1;
                } else if (buffer[0] == 'B') {
                    digitalclock = 0;
                    digitalclock_colon = 0;
                    for(float p = 0.8f; p > 0.0f; p -= 0.01f) {
                        meter_LED_outside = p;
                        meter_LED_inside = p;
                        P_range_LED = p;
                        D_range_LED = p;
                        Other_range_LED = p;
                        needle_LED = p;
                        wait(0.01);
                    }
                } else if (buffer[0] == 'P') {
                    meter_LED_outside = ((target / 10.0));
                } else if (buffer[0] == 'Q') {
                    meter_LED_inside = ((target / 10.0));
                } else if (buffer[0] == 'R') {
                    needle_LED = ((target / 10.0));
                } else if (buffer[0] == 'C') {
                    /*
                    int count_1 = 0;
                    int t = 0;
                    P_range_LED = 0;
                    D_range_LED = 0.1;
                    while(count_1 < 8) {
                        if (t ==0) {
                            wait(10.0);
                            meter_LED_outside_flashing1();
                        } else if (t == 1) {
                            wait_ms(2500-700);
                            meter_LED_outside_flashing1();
                        } else if (t == 2) {
                            wait_ms(2200-700);
                            meter_LED_outside_flashing1();
                        } else if (t == 3) {
                            wait_ms(2500-700);
                            meter_LED_outside_flashing1();
                        } else if (t == 4) {
                            wait_ms(4000-700);
                            meter_LED_outside_flashing2();
                        } else if (t == 5) {
                            wait_ms(4000-700);
                            meter_LED_outside_flashing2();
                        } else if (t == 6) {
                            wait_ms(6000-700);
                            meter_LED_outside_flashing2();
                        } else if (t == 7) {
                            wait(36);
                            D_range_LED = 0;
                            P_range_LED = 0.1;
                            t = 0;
                        }
                        wait_ms(200);

                        t++;
                        count_1++;
                    }
                    */
                    switch (target) {
                        case 0:
                            D_range_LED = 0.1;
                            P_range_LED = 0;
                            break;

                        case 1:
                            meter_LED_outside_flashing2();
                            break;
                            
                        case 2:
                            meter_LED_outside_flashing2();
                            break;
                            
                        default:
                            D_range_LED = 0;
                            P_range_LED = 0.1;
                            break;
                    }
                } else if (buffer[0] == 'K') {
                    for (int i = 0; i < 5; i++) {
                        signal_LED_L = 1;
                        wait (0.5);
                        signal_LED_L = 0;
                        if (i < 4) wait (0.5);
                    }
                } else if (buffer[0] == 'L') {
                    for (int i = 0; i < 5; i++) {
                        signal_LED_L = 1;
                        signal_LED_R = 1;
                        wait (0.5);
                        signal_LED_L = 0;
                        signal_LED_R = 0;
                        if (i < 4) wait (0.5);
                    }
                } else if (buffer[0] == 'M') {
                    for (int i = 0; i < 5; i++) {
                        signal_LED_R = 1;
                        wait (0.5);
                        signal_LED_R = 0;
                        if (i < 4) wait (0.5);
                    }
                } else if (buffer[0] == 'S') {
                    meter_LED_outside = 0.1;
                    meter_LED_inside = 0.1;
                    needle_LED = 1.0;
                }
            }
            digitalclock_colon = 1;
            wait (0.5);
            digitalclock_colon = 0;
            //wait (0.25);
        }
    }
}

