#include "mbed.h"
#include "SDFileSystem.h"

#include "EthernetInterface.h"

#define ECHO_SERVER_PORT   10373

/*
    GND:
    VIN:
    VB :
    nR :
    p5 : mosi SD_DIN(37)
    p6 : miso SD_OUT(35)
    p7 : sck  SD_SCL(36)
    p8 : SD_CS(38)
    p9 : LCD_RESET(17)
    p10: LCD_CNT
    p11: LCD_DATA(HC164-AB)
    p12:
    p13: LCD_CLK(HC164-CLK)
    p14: LCD_CS1(15)
    p15: LCD_CS2(16)
    p16: RS(4)
    p17: WR(5)
    p18: CLR(HC164-CLR)
    p19:
    p20:

    p21:
    p22:
    p23:
    p24:
    p25:
    p26:
    p27:
    p28:
    p29:
    p30:
    D+
    D-
    TD+
    TD-
    RD+
    RD-
    IF+
    IF-
    VU
    VOUT
*/

typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned long u32;

DigitalOut LCD_RESET(p9);
DigitalOut LCD_CNT(p10);
DigitalOut LCD_CS(p14);
DigitalOut LCD_CLR(p18);
DigitalOut LCD_RS(p16);
DigitalOut LCD_WR(p17);

SPI lcdSerial(p11, NC, p13);

u16 DeviceCode = 0;

//Serial pc(USBTX, USBRX);

#define LCD_WR_CMD(data){\
    LCD_CLR=0;\
    LCD_CLR=1;\
    lcdSerial.write(data);\
    LCD_RS=0;\
    LCD_CS=0;\
    LCD_WR=0;\
    wait_us(500);\
    LCD_WR=1;\
    LCD_CS=1;\
}

#define LCD_WR_DATA(data){\
    LCD_CLR=0;\
    LCD_CLR=1;\
    lcdSerial.write(data);\
    LCD_RS=1;\
    LCD_CS=0;\
    LCD_WR=0;\
    LCD_WR=1;\
    LCD_CS=1;\
}

#define WHITE 0xffff

LocalFileSystem local("local");

void LCD_Clear(u16 Color);

void LCD_WriteReg(u16 LCD_Reg, u16 LCD_RegValue)
{
    LCD_WR_CMD(LCD_Reg);
    LCD_WR_DATA(LCD_RegValue);
}

void LCD_Init1289(void)
{
    LCD_CNT = 1;
    LCD_RESET = 0;
    LCD_CS = 1;
    wait_ms(50); // delay 50 ms
    LCD_RESET = 1;
    wait_ms(50); // delay 50 ms
    LCD_WriteReg(0x0000,0x0001);
    wait_ms(50); // delay 50 ms
    LCD_WriteReg(0x0000,0x0001);
    wait_ms(6);  //&#65533;L&#242;&#191;&#170;&#190;&#65533;&#65533;&#213;&#241;
    LCD_WriteReg(0x0003,0xA8A4);
    wait_ms(6);   //0xA8A4
    LCD_WriteReg(0x000C,0x0000);
    wait_ms(6);
    LCD_WriteReg(0x000D,0x080C);
    wait_ms(6);
    LCD_WriteReg(0x000E,0x2B00);
    wait_ms(6);
    LCD_WriteReg(0x001E,0x00B7);
    wait_ms(6);
    LCD_WriteReg(0x0001,0x2B3F);
    wait_ms(6);   //&#199;&#253;&#65533;&#65533;&#175;&#202;&#228;&#179;&#246;&#191;&#216;&#214;&#198;320*240  0x6B3F
    LCD_WriteReg(0x0002,0x0600);
    wait_ms(6);
    LCD_WriteReg(0x0010,0x0000);
    wait_ms(6);
    LCD_WriteReg(0x0011,0x6070);
    wait_ms(6);        //0x4030           //&#65533;&#65533;&#65533;N&#210;&#229;&#202;&#253;&#190;&#221;&#184;&#241;&#202;&#189;  16&#206;&#187;&#201;&#171;
    LCD_WriteReg(0x0005,0x0000);
    wait_ms(6);
    LCD_WriteReg(0x0006,0x0000);
    wait_ms(6);
    LCD_WriteReg(0x0016,0xEF1C);
    wait_ms(6);
    LCD_WriteReg(0x0017,0x0003);
    wait_ms(6);
    LCD_WriteReg(0x0007,0x0233);
    wait_ms(6);        //0x0233
    LCD_WriteReg(0x000B,0x0000);
    wait_ms(6);
    LCD_WriteReg(0x000F,0x0000);
    wait_ms(6);        //&#201;&#65533;N&#195;&#232;&#191;&#170;&#202;&#188;&#181;&#216;&#214;&#183;
    LCD_WriteReg(0x0041,0x0000);
    wait_ms(6);
    LCD_WriteReg(0x0042,0x0000);
    wait_ms(6);
    LCD_WriteReg(0x0048,0x0000);
    wait_ms(6);
    LCD_WriteReg(0x0049,0x013F);
    wait_ms(6);
    LCD_WriteReg(0x004A,0x0000);
    wait_ms(6);
    LCD_WriteReg(0x004B,0x0000);
    wait_ms(6);
    LCD_WriteReg(0x0044,0xEF00);
    wait_ms(6);
    LCD_WriteReg(0x0045,0x0000);
    wait_ms(6);
    LCD_WriteReg(0x0046,0x013F);
    wait_ms(6);
    LCD_WriteReg(0x0030,0x0707);
    LCD_WriteReg(0x0031,0x0204);
    LCD_WriteReg(0x0032,0x0204);
    LCD_WriteReg(0x0033,0x0502);
    LCD_WriteReg(0x0034,0x0507);
    LCD_WriteReg(0x0035,0x0204);
    LCD_WriteReg(0x0036,0x0204);
    LCD_WriteReg(0x0037,0x0502);
    LCD_WriteReg(0x003A,0x0302);
    LCD_WriteReg(0x003B,0x0302);
    wait_ms(6);
    LCD_WriteReg(0x0023,0x0000);
    wait_ms(6);
    LCD_WriteReg(0x0024,0x0000);
    wait_ms(6);
    LCD_WriteReg(0x0025,0x8000);
    wait_ms(6);
    LCD_WriteReg(0x004f,0);        //&#208;&#208;&#202;&#65533;~&#214;&#183;0
    LCD_WriteReg(0x004e,0);        //&#193;&#208;&#202;&#65533;~&#214;&#183;0

//    LCD_WriteReg(0X07,0X0133);
//    }
    LCD_CNT = 0;
    //LCD_Clear(WHITE);
}

void LCD_WriteRAM_Prepare(void)
{
    LCD_WR_CMD(0x22);
}

void LCD_WriteRAM(u16 RGB_Code)
{
    LCD_WR_DATA(RGB_Code);
}

void LCD_SetCursor(u16 Xpos, u16 Ypos)
{
//    LCD_WriteReg(0x4E, Ypos);
//    LCD_WriteReg(0x4F, 319 - Xpos);

    LCD_WriteReg(0x20, Ypos);
    LCD_WriteReg(0x21, 319 - Xpos);
}

void LCD_Clear(u16 Color)
{
    u32 index=0;
    LCD_SetCursor(0x00,0x0000);//&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;
    LCD_WriteRAM_Prepare();     //&#65533;I&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;GRAM
    for(index=0; index<76800; index++) {
        LCD_WR_DATA(Color);
    }
}

void LCD_Clear2()
{
    u32 i;
    u32 j;
    LCD_SetCursor(0x00,0x0000);//&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;
    LCD_WriteRAM_Prepare();     //&#65533;I&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;GRAM
    for(i = 0; i < 320; i++) {
        for (j = 0; j < 240; j++) {
            if (j < 60) {
                LCD_WR_DATA(0xf000);
            } else if (j < 120) {
                LCD_WR_DATA(0x0f00);
            } else if (j < 180) {
                LCD_WR_DATA(0x00f0);
            } else {
                LCD_WR_DATA(0x000f);
            }
        }
    }
}

void LCD_Clear3()
{
    u32 i,j;
    int shift;
    LCD_WriteReg(0x0016,0x771C);
    LCD_SetCursor(0x00,0x0000);//&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;
    LCD_WriteRAM_Prepare();     //&#65533;I&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;GRAM
    for(i = 0; i < 320; i++) {
        if (i < 107) {
            shift = -2;
        } else if (i < 214) {
            shift = 3;
        } else {
            shift = 9;
        }
        for(j = 0; j < 240; j++) {
            if (shift > 0) {
                LCD_WR_DATA(((j & 0xfc) << shift));// | ((j & 0xf0) >> 4));
            } else {
                LCD_WR_DATA(((j & 0xfc) >> (-shift)));
            }
        }
    }
}

void LCD_Clear4(u16 color)
{
    u32 index=0;
    LCD_SetCursor(0x00,0x0000);//&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;
    LCD_WriteRAM_Prepare();     //&#65533;I&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;GRAM
    LCD_CLR=0;
    LCD_CLR=1;
    lcdSerial.write(color);
    LCD_RS=1;
    LCD_CS=0;
    for(index=0; index<9600; index++) {
        LCD_WR=0;
        LCD_WR=1;
        LCD_WR=0;
        LCD_WR=1;
        LCD_WR=0;
        LCD_WR=1;
        LCD_WR=0;
        LCD_WR=1;
        LCD_WR=0;
        LCD_WR=1;
        LCD_WR=0;
        LCD_WR=1;
        LCD_WR=0;
        LCD_WR=1;
        LCD_WR=0;
        LCD_WR=1;
    }
    LCD_CS=1;
}

void LCD_Paint(int pict)
{
    FILE *fp;
    switch (pict) {
        case 0:
            fp = fopen("/local/pict001.pic", "r");
            break;
        case 1:
            fp = fopen("/local/pict002.pic", "r");
            break;
        case 2:
            fp = fopen("/local/pict003.pic", "r");
            break;
        default:
            fp = fopen("/local/pict004.pic", "r");
            break;
    }
    if(fp == NULL) {
        LCD_Clear4(0);
    } else {
        LCD_SetCursor(0x00,0x0000);
        LCD_WriteRAM_Prepare();
        for (int i = 0; i < 320; i++) {
            u16 buffer[240];
            fread((void*)buffer, sizeof(u8), 480, fp);
            for(int j = 0; j < 240; j++) {
                //u16 b = (buffer[j] << 8) | ((buffer[j] >> 8) & 0x0f);
                LCD_WR_DATA(buffer[j]);
            }
        }
    }
    fclose(fp);
}

int main()
{
    lcdSerial.format(16, 3);
    lcdSerial.frequency(100000);
    LCD_CLR = 1;

    LCD_Init1289();
    lcdSerial.frequency(30000000);

    LCD_Paint(0);

    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());

    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();

    while (1) {
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 1500);
        printf("Client connected %s\n", client.get_address());

        char buffer[256];

        while (true) {
            int n = client.receive(buffer, sizeof(buffer));

            int pict = (buffer[0] - 'H');
            LCD_Paint(pict);
        }

        return 0;
    }
}