#include "mbed.h"

// http://www.aitendo.com/product/5440
// FSTN LCD(128x64/SPI) [C128X64SPI-12P]
// 2bit color



#define SCREEN_WIDTH    128
#define SCREEN_HEIGHT   64
#define PAGE_SEL        0xB0
#define COL_SEL      0x10

SPI spi(p5, p6, p7);        // mosi, miso, sclk
DigitalOut pin_cs0(p8);
DigitalOut pin_a0(p9);
DigitalOut pin_rst(p10);


void spi_write_cmd(unsigned char cmd) {
    pin_cs0 = 0;
    pin_a0  = 0;
    spi.write(cmd);
    pin_cs0 = 1;
}

void spi_write_dat(unsigned char dat) {
    pin_cs0 = 0;
    pin_a0  = 1;
    spi.write(dat);
    pin_cs0 = 1;
}

void init() {
    spi.format(8, 3);           // 8bit, mode3
    spi.frequency(1000000);     // 1MHz:default
    
    // http://aitendo3.sakura.ne.jp/aitendo_data/product_img/lcd/fstn/COG128X64SPI-12P/st7567_init_code.txt
    // http://aitendo3.sakura.ne.jp/aitendo_data/product_img/lcd/fstn/COG128X64SPI-12P/st7567_demo_code.txt
    pin_rst = 0;
    wait_ms(100);
    pin_rst = 1;
    
    spi_write_cmd(0xE2);            // S/W RESWT
    spi_write_cmd(0xA3);            // LCD bias
    spi_write_cmd(0xAF);            // Display ON
    spi_write_cmd(0xA0);            // segment direction.
    spi_write_cmd(0xC8);            // Common Direction.
    spi_write_cmd(0x22);            // Regultion resistor select  //25
    spi_write_cmd(0x81);            // EV Select.
    spi_write_cmd(0x2f);            // Select EV value.
    spi_write_cmd(0x2f);            // Power control
    
    spi_write_cmd(0x40);            // Initial display line 40
    spi_write_cmd(0xB0);            // Set page address
    spi_write_cmd(0x10);            // Set coloumn addr  MSB
    spi_write_cmd(0x00);            // Set coloumn addr LSB
    spi_write_cmd(0xAF);            // Display ON
    spi_write_cmd(0xA4);            // A5 .Normal display, all pixels OFF.
    spi_write_cmd(0xA6);            // A7 .Normal display (Inverse Pixel)       
}

void glcd_set_pixel(int x, int y, int ptn) {

    int page;
    
    page = y / 8;
    
    /* Selecting Page */
    spi_write_cmd(PAGE_SEL | page);
    
    /* Selecting Column */
    spi_write_cmd(COL_SEL | ((x & 0xF0) >> 4));
    spi_write_cmd(            x & 0x0F);
    
    spi_write_dat(ptn);
}

int main() {
    init();
    
    for (int iii = 0; iii < SCREEN_WIDTH; iii++) {
        for (int jjj = 0; jjj < SCREEN_HEIGHT; jjj += 8) {
            int ptn = 0;
            for (int ttt = 0; ttt < (iii + (jjj / 4)) % 8; ttt++) {
                ptn = (ptn << 1) | 1;
            }
            glcd_set_pixel(iii, jjj, (ptn & 0xff));
        }
    }
    
    return 0;
}
