#include "mbed.h"

// digital volume for FN1242A.
//
// FN1242A : 24bit/192KHz/2ch DAC
// http://akizukidenshi.com/download/ds/niigataseimitsu/FN1242Ajspec.pdf


// LPC1114FN28
//  3  SWCLK
//  4  PIO0_11   to VR10k (AnalogIN)
//  7  AVIN 3.3V
//  8  AGND
//  9  PIO1_0    to FN1242A (ML)
// 10  PIO1_1    to FN1242A (MD)
// 11  PIO1_2    to FN1242A (MC)
// 12  SWDIO
// 21  VIN 3.3V
// 22  GND
// 23  RESET


AnalogIn    pin_VR(dp4);
DigitalOut  pin_ML(dp9);
DigitalOut  pin_MD(dp10);
DigitalOut  pin_MC(dp11);


void send_cmd(uint16_t word) {
    
    pin_ML = 1;
    
    for (int iii = 0; iii < 16; iii++) {
        pin_MC = 0;
        pin_MD = (word & 0x8000) == 0 ? 0 : 1;      // msb first
        wait_us(10);            // us
        
        pin_MC = 1;
        wait_us(10);            // us
        
        word = word << 1;
    }
    
    pin_MD = 0;
    pin_MC = 0;
    pin_ML = 0;
    wait_us(10);                // us
    
    pin_ML = 1;
    wait_us(10);                // us
}

uint16_t new_vol = 0;
uint16_t cur_vol = 0;

int main() {
    
    wait_ms(100);               // ms
    
    pin_ML = 1;
    pin_MD = 0;
    pin_MC = 0;
    wait_us(10);                // us
    
    while (1) {
        new_vol = pin_VR.read_u16() >> 6;   // 10bit (0-1023)
        
        if (cur_vol <= new_vol - 8) {
            new_vol = (new_vol - 8) | 0x3f;   // 6bit
            
        } else 
        if (new_vol + 8 <= (cur_vol - 0x40)) {
            new_vol = (new_vol + 8) | 0x3f;   // 6bit
    
        } else {
            new_vol = cur_vol;
        }
        
        if (new_vol != cur_vol) {
            cur_vol = new_vol;
            
            send_cmd(
                  (0 << 11)     // MODE0
                | (1 << 10)     // LDL
                | new_vol);     // 10bit
            
            send_cmd(
                  (1 << 11)     // MODE1
                | (1 << 10)     // LDR
                | new_vol);     // 10bit
        }
        
        wait_ms(100);           // ms
    }

}
