/////////////////////////////////////
/*NHK2019*/
/*Aチーム手動機リミットスイッチ用プログラム*/
////////////////////////////////////

#include "mbed.h"
Serial master(PC_6,PC_7);
Serial pc(USBTX,USBRX);
DigitalIn limit0(D10);//右上ラック
DigitalIn limit1(D9);//左上ラック
DigitalIn limit2(D8);//右下ラック
DigitalIn limit3(D7);//左下ラック

DigitalIn limit4(D6);//回収機構右
DigitalIn limit5(D5);//回収機構左
DigitalIn limit6(D4);//吐き出し1
DigitalIn limit7(D2);//吐き出し2
DigitalOut green(D12);//電源確認
DigitalOut red(D11);//動作確認

//データ格納用変数
char data=0x00;



//関数プロトタイプ宣言
void send_data(char send);

//main()関数
int main()
{
    
    master.baud(115200);
    pc.baud(115200);

    limit0.mode(PullUp);

    limit1.mode(PullUp);

    limit2.mode(PullUp);

    limit3.mode(PullUp);

    limit4.mode(PullUp);

    limit5.mode(PullUp);

    limit6.mode(PullUp);

    limit7.mode(PullUp);

    while(true) {
        
        red=1;

        if(!limit0) {
            data = data | 0x01;
        } else {
            data = data & 0b11111110;
        }
        if(!limit1) {
            data = data | 0x02;
        } else {
            data = data & 0b11111101;
        }
        if(!limit2) {
            data = data | 0x04;
        } else {
            data = data & 0b11111011;
        }
        if(!limit3) {
            data = data | 0x08;
        } else {
            data = data & 0b11110111;
        }
        if(!limit4) {
            data = data | 0x10;
        } else {
            data = data & 0b11101111;
        }
        if(!limit5) {
            data = data | 0x20;
            green=1;
        } else {
            data = data & 0b11011111;
            green=0;
        }
        if(!limit6) {
            data = data | 0x40;
        } else {
            data = data & 0b10111111;
        }
        if(!limit7) {
            data = data | 0x80;
        } else {
            data = data & 0b01111111;
        }
        
        


        send_data(data);
        
        red=0;
        
        pc.printf("0x%x\n",data);

    }

}

//rs232通信
void send_data(char send)
{
    master.putc(send);
    wait(0.02);
}