#include "mbed.h"
#include "QEI.h"
QEI rori(PA_6,PA_8,NC,600);
Serial pc(USBTX,USBRX);
Ticker get_rpm;

/*
使用エンコーダー:LPD3806-600BM-G5-24C
分解能:600(QEIのデフォルトで2倍の1200を読んでいる)
1ms毎にパルスを読む
1ms*1000=1s
rps*60=rpm
表示する値:1msあたりのパルス,これまでの合計パルス、rpm
*/

int rpm=0;
int pulse=0;
int sum_pulse=0;

void change_rpm();

int main(){
    pc.baud(9600);
    get_rpm.attach_us(&change_rpm,1000);
    while(true){
        pc.printf("pulse:%d sum_pulse:%d rpm:%d\n",pulse,sum_pulse,rpm);
    }
}

void change_rpm(){
    pulse=rori.getPulses();
    sum_pulse=sum_pulse+pulse;
    rori.reset();
    rpm=60*1000*pulse/1200;
}