#ifndef IR_COMMUNICATION_H
#define IR_COMMUNICATION_H

#include "mbed.h"

#define IR_ON 0.33
#define IR_OFF 0
#define SIZE 500

class IR_Comm{
    public:
        IR_Comm(PinName IR_in, PinName IR_out, const int data_size); //(PinName of InterruptIn, PinName of PwmOut, Data size of array)
        
        void IR_send(int *);
        void IR_data_reset(int *);
        void ir_rise(void);
        void ir_fall(void);
        void get_data(int *);
        void receive_start();
        void receive_stop();
        
    private:
        InterruptIn IR_in;  //赤外線受信 PA_0
        PwmOut IR_LED;   //赤外線送信 PA_1 
        Timer timer;
        
        int temp_data[SIZE];
        int receive_flag;
        int i;
        int size;
};

#endif