#include "mbed.h"
#include "IR_Communication.h"

IR_Comm::IR_Comm(PinName in, PinName out, const int data_size):IR_in(in), IR_LED(out) ,size(data_size) {
    IR_LED.period(0.000026315); //38KHz
    
    //reference https://os.mbed.com/questions/75943/Deprecated-method-mbedInterruptInfall/
    IR_in.rise(callback (this, &IR_Comm::ir_rise));
    IR_in.fall(callback (this, &IR_Comm::ir_fall));
    timer.start();
}

void IR_Comm::receive_start(){
    receive_flag = 1;
    timer.reset();
    i = 0;
}

void IR_Comm::receive_stop(){
    receive_flag = 0;
    i = 0; 
}

void IR_Comm::IR_send(int *data){    
    for (i = 1; i < size; i++){
        timer.reset();
        if(i % 2 != 0){  //奇数番
            while(timer.read_us() <= data[i])    IR_LED = IR_ON;
        }
        else{
            while(timer.read_us() <= data[i])    IR_LED = IR_OFF;
        }
        
    }
    i = 0;
    IR_LED = IR_OFF;
}

void IR_Comm::ir_rise(void){
    if(receive_flag == 1){
        temp_data[i] = timer.read_us();
        timer.reset();
        i++;
        if(i > size) i = size;
    }
}

void IR_Comm::ir_fall(void){ 
    if(receive_flag == 1){
        temp_data[i] = timer.read_us();
        timer.reset();
        i++;
        if(i > size) i = size;
    }
}

void IR_Comm::IR_data_reset(int *data){
    for (i = 0; i < size; i++){
        data[i] = 0;
        temp_data[i] = 0;
    }
    i = 0;    
}

void IR_Comm::get_data(int *data){
    for (i = 0; i < size; i++){
        data[i] = temp_data[i];
    }  
    i = 0;
}
