#include "mbed.h"
#include "Global.h"
#include "Display.h"
extern RawSerial pc;

//swは接続要求のスイッチのつもりだったが今は使っていない
Display::Display(PinName tx, PinName rx, PinName sw) : _blt_serial(tx, rx), _sw(sw){
    if(sw != NC){
        _sw.mode(PullUp);
        swisvalid = true;
    }else{
        swisvalid = false;
    }
    _blt_serial.baud(115200);
}

//送信されるGlobal時刻とデータの取得時刻との最大誤差 = min{Displayのupdateの更新間隔, データの更新間隔}
void Display::update(){
    //現在androidからbluetoothモジュールへの接続要求が不安定。何度か失敗した後に接続される。
    //一方でbluetoothモジュールからandroidへの接続要求は一発で通る。（これをやりたいならbluetoothモジュールの設定を変更する必要あり）
    //そこで、bluetoothモジュールにmbedから接続要求をさせるコマンドを送信するプログラムをここに記す。
    //（このプログラムでは、接続中にスイッチが押された時，通信が固まる（mbedからandroidへの接続は別の方法を考えるべきかも））
    //改善策としては、android側のプログラムを見なおしたほうが近道になるかもしれない。
    if(swisvalid == true && _sw == 0){//これを逆に書くと，NCの_swが呼び出されてエラー領域に入る
        _blt_serial.printf("$$$");//コマンドモード http://akizukidenshi.com/download/ds/akizuki/AE-RN42_manual_r1.pdf
        wait_ms(50);
        _blt_serial.printf("c\n---\n");//mbed側からandroidへ接続するコマンド データ転送モード
        swisvalid = false;//1度きりのコネクトスイッチ
    }
    
    _blt_serial.printf("#%d,",Global::timer.read_ms());

    //最新の値のみを送信するため、値が更新されたGlobalの時間を使用する。その値が古いものであるときは"N"を送信  
    //pre~ではじまる変数はDisplay.h内で宣言されていて、このクラス内で保持されている。Global内の時間と比較  
    /*if(preselectortime != Global::getselectortime()){
        _blt_serial.printf("%d,",Global::getselector());
    }else{
        _blt_serial.printf("N,");
    }*/
    if(prepitchtime != Global::getpitchtime()){
        _blt_serial.printf("%.2f,",Global::getpitch());    
    }else{
        _blt_serial.printf("N,");
    }
    if(preyawtime != Global::getyawtime()){
        _blt_serial.printf("%.2f,",Global::getyaw());    
    }else{
        _blt_serial.printf("N,");
    }
    if(preinttrimpitchtime != Global::getinttrimpitchtime()){
        _blt_serial.printf("%d,",Global::getinttrimpitch());    
    }else{
        _blt_serial.printf("N,");
    }
    if(preairspeedtime != Global::getairspeedtime()){
        _blt_serial.printf("%.2f,",Global::getairspeed());    
    }else{
        _blt_serial.printf("N,");
    }
    
    if(precadencetime != Global::getcadencetime()){
        _blt_serial.printf("%.2f,",Global::getcadence());    
    }else{
        _blt_serial.printf("N,");
    }
    if(preultsonictime != Global::getultsonictime()){
        _blt_serial.printf("%.2f,",Global::getultsonic());    
    }else{
        _blt_serial.printf("N,");
    }
    if(prepowermetertime != Global::getpowermetertime()){
        _blt_serial.printf("%.2f,",Global::getpowermeter());    
    }else{
        _blt_serial.printf("N,");
    }
  //  if(preatmpresstime != Global::getatmpresstime()){
//        _blt_serial.printf("%.2f,",Global::getatmpress());    
//    }else{
//        _blt_serial.printf("N,");
//    } //出力計に使おう。
    if(precadencevolttime != Global::getcadencevolttime()){
        _blt_serial.printf("%.2f,",Global::getcadencevolt());    
    }else{
        _blt_serial.printf("N,");
    }
     if(preultsonicvolttime != Global::getultsonicvolttime()){
        _blt_serial.printf("%.2f,",Global::getultsonicvolt());    
    }else{
        _blt_serial.printf("N,");
    }
    if(preservovolttime != Global::getservovolttime()){
        _blt_serial.printf("%.2f,",Global::getservovolt());    
    }else{
        _blt_serial.printf("N,");
    }
    
    _blt_serial.printf("~\n\r");    
    
    //preselectortime     = Global::getselectortime();    
    prepitchtime        = Global::getpitchtime();
    preyawtime          = Global::getyawtime();
    preinttrimpitchtime = Global::getinttrimpitchtime();
    preairspeedtime     = Global::getairspeedtime();
    precadencetime      = Global::getcadencetime();
    preultsonictime     = Global::getultsonictime();
    prepowermetertime   = Global::getpowermetertime();
//    preatmpresstime     = Global::getatmpresstime();
    precadencevolttime  = Global::getcadencevolttime();
    preultsonicvolttime = Global::getultsonicvolttime();
    preservovolttime    = Global::getservovolttime();
}
