#include "mbed.h"
#include "Global.h"
#include "TweLite_Sensors.h"
#include <string>
//extern RawSerial pc;


std::string TweLite_Sensors::str;

TweLite_Sensors::TweLite_Sensors(PinName tx, PinName rx) : twelite(tx,rx) {
    receivef = 0;
    request = CADENCE;
    size = 0;
    twelite.baud(9600);
    twelite.attach(this, &TweLite_Sensors::twelite_rx, Serial::RxIrq); //twe-liteからの受診を検知
    flipper.attach(this, &TweLite_Sensors::flip, UPDATECYCLE / 3);    //twe-liteへのデータ送信要求
}

/* twelite-rx()でstrに格納されたデータをscanする
 * クラス変数strに情報が格納されており、それをstrの先頭charを元にどちらのセンサーからの
 * 情報なのかを判別し、処理
 * strのサイズが45を越えるとまずいらしい(一番下)。基本的にstr[8]までしか使わない
 */
void TweLite_Sensors::scan() {
    while(size<9){wait_ms(1);}//ここを空にするとループを抜けなくなる
    if (str[0] == CADENCEHEADER) {//ヘッダ
        for (int i = 0; i < 8; i++) {
            data[i] = str[i+1];
        }
        for(int i = 0; i <= size-9; i++) str[i] = str[i+9];
        size-=9;
        cadencevalue = *(float*) data;
        cadenceBattery = *(float*) (data+4);
        Global::setcadence(cadencevalue);
        Global::setcadencevolt(cadenceBattery);
    } else if (str[0] == ULTSONICHEADER) {
        for(int i = 0; i < 8; i++){
            data[i] = str[i+1];
        }
        for(int i = 0; i <= size-9; i++) str[i] = str[i+9];
        size-=9;
        ultsonicvalue = *(float*) data;
        ultsonicBattery = *(float*) (data+4);
        Global::setultsonic(ultsonicvalue);
        Global::setultsonicvolt(ultsonicBattery);
    } else if (str[0] == POWERMETERHEADER) {
        for(int i = 0; i < 8; i++){
            data[i] = str[i+1];
        }
        for(int i = 0; i <= size-9; i++) str[i] = str[i+9];
        size-=9;
        powermetervalue = *(float*) data;
        powermeterBattery = *(float*) (data+4);
        Global::setpowermeter(powermetervalue);
        Global::setpowermetervolt(powermeterBattery);
    } else {
        for(int i = 0; i <= size-9; i++) str[i] = str[i+9];
        size-=9;
    }
    //pc.printf("%d",size);//45以上になるとRTX error code: 0x00000001, task ID: 0x20000540
}

/* twe-lite経由でデータを得るための関数
 * この関数でstrに
 * 　センサー固有のヘッダ・センサーからの情報(データ・電池の状況)
 * をまとめて格納
 */
void TweLite_Sensors::twelite_rx() {
    while (twelite.readable()) {
        if (receivef == 0) {
            char c = twelite.getc();
//            pc.putc(c);
            if (c == CADENCEHEADER) {
                receivef = 1;
                str[size] = CADENCEHEADER;//pushできない size()は0のまま//両方できるっぽい
                size++;
            } else if (c == ULTSONICHEADER) {
                receivef = 1;
                str[size] = ULTSONICHEADER;
                size++;
            } else if (c == POWERMETERHEADER) {
                receivef = 1;
                str[size] = POWERMETERHEADER;
                size++;
            } else {}//先頭がheaderではないとき
        } else if (receivef == 1) {
            str[size] = twelite.getc();
//            pc.putc(str[size]);
            size++;
        }
        if(size%9 == 0) receivef = 0;
    }
}

//twe-liteにデータを送るよう要求
//rquestによって指定
void TweLite_Sensors::flip() {
    if (request == CADENCE){
        twelite.putc(CADENCE);
        request = ULTSONIC;
    } else if (request == ULTSONIC) {
        twelite.putc(ULTSONIC);
        request = POWERMETER;
    } else if (request == POWERMETER) {
        twelite.putc(POWERMETER);
        request = CADENCE;
    }
    //Global::led=!Global::led;
}

void TweLite_Sensors::update(){
    scan();
}