#include "mbed.h"
#include "PitotAirspeed.h"
extern RawSerial pc;

std::string PitotAirspeed::str;

PitotAirspeed::PitotAirspeed(RawSerial &_serial) : serial(_serial) {
    receivef = 0;
    size = 0;
    serial.attach(this, &PitotAirspeed::rx_recieve, Serial::RxIrq); //受信を検知
}

PitotAirspeed::PitotAirspeed(PinName tx, PinName rx) : serial(tx, rx) {
    receivef = 0;
    size = 0;
    serial.baud(115200);
    serial.attach(this, &PitotAirspeed::rx_recieve, Serial::RxIrq); //受信を検知
}

void PitotAirspeed::rx_recieve() {
    while (serial.readable()) {
        if (receivef == 0) {
            char c = serial.getc();
            if (c == PITOTHEADER){
                receivef = 1;
                str[size] = PITOTHEADER;//pushできない size()は0のまま//両方できるっぽい
                size++;
            } else {
                //先頭がheaderではないとき
            }   
        } else if (receivef == 1) {
            str[size] = serial.getc();
            size++;
        }
        if (size%5 == 0) receivef = 0;
    }
}

void PitotAirspeed::update(){
    if (size<5) {
        return;//ここを空にするとループを抜けなくなる
    }
    if (str[0] == PITOTHEADER){//ヘッダ
        for (int i = 0; i < 4; i++) {
            data[i] = str[i + 1];
        }
        for (int i = 0; i <= size-5; i++) str[i] = str[i+5];
        size-=5;
        airspeed = *(float*)data;
//        pc.printf("%f [m/s]", airspeed);
        Global::setairspeed(airspeed);
    }else{
        for(int i=0; i <= size-5; i++) str[i] = str[i+5];
        size-=5;
    }
    //pc.printf("%d",size);//45以上になるとRTX error code: 0x00000001, task ID: 0x20000540
}