#ifndef BIRD_SENSOR_ATMPRESS_H_
#define BIRD_SENSOR_ATMPRESS_H_
#include "mbed.h"
#include "Global.h"

#define LPS331_ADDRESS        0xB8

#define LPS331_WHO_AM_I       0x0F

#define LPS331_PRESS_OUT_XL   0x28
#define LPS331_PRESS_OUT_L    0x29
#define LPS331_PRESS_OUT_H    0x2A

#define LPS331_TEMP_OUT_L     0x2B
#define LPS331_TEMP_OUT_H     0x2C

#define LPS331_CTRL_REG1      0x20
#define LPS331_CTRL_REG2      0x21
#define LPS331_CTRL_REG3      0x22


class Atmpress {
    protected :
    I2C i2c;
    Timeout timeout;
    char readbyte(char cmd);
    int32_t addbyte(char xl, char l, char h);
    uint16_t addbyte(char l, char h);
    double calcpressure(int32_t raw);
    double calctemperature(uint16_t raw);
    
    public : 
    Atmpress(PinName sda, PinName scl);
    void init();
    double getpressure();
    double gettemperature();
    void update();
    
};

#endif