#include "mbed.h"
#include "Global.h"
#include "Airspeed.h"
#include "RotaryEncoder.h"
#include "math.h"



Airspeed::Airspeed(PinName chanA, PinName chanB, PinName index) 
    : onepulserotaryencoder(chanA, chanB, index, 2, RotaryEncoder::X2_ENCODING){
}

//機速の計算
double Airspeed::calc(double input){
    if(input==0) return 0;
    return -0.0003*(0.83*input/60)*(0.83*input/60)+0.1005*(0.83*input/60)+0.4617;
/*    double a,b,c;
    a=0.0602;
    b=-0.8822;
    c=4.501;
    if(input/60 < 7.6)
        return 0.16756*(input/60);
    else return a*(input/60)*(input/60)+b*(input/60)+c;
  */  
    /*double a;
    double b; 
    if(input*0.001*1.6 < 2){
        a = 0.001*1.6*0.9824;
        b = 0;
    }else{
        a = 0.001*1.6*0.5815;
        b = 0.8;
    }
    return (input*a + b)*1.2754;//機速計の特性に合わせて変更
    */
}

//rpm内で同じ処理をしている。いらないかも
void Airspeed::initialize(){
    pasttime = Global::timer.read();
    onepulserotaryencoder.reset();
}

//Global内の変数にセット
void Airspeed::update(){
   Global::setairspeed(calc(rpm(read(),Global::timer.read())));
   //Global::setairspeed(rpm(read(),Global::timer.read())/60);
}

double Airspeed::read(){
    //rotaryencoderの回転数

    return onepulserotaryencoder.getfloatrevolutions();
}
//pasttimeの初期化コンストラクタでした方がいいかも
double Airspeed::rpm(double revolutions,double time){
    double rpm_ = revolutions/(time-pasttime)*60;
    onepulserotaryencoder.reset();
    pasttime = time;
    return rpm_;
}
double Airspeed::get(){
    return calc(rpm(read(),Global::timer.read()));
}