#ifndef BIRD_CENTRAL_GLOBAL_H_
#define BIRD_CENTRAL_GLOBAL_H_

#include "mbed.h"
#include "rtos.h"
#include "FlashManager.h"

//各変数はGlobal.cpp内に説明あり

class Global {
    
    static class SPI spi;//フラッシュメモリとのSPI通信のための変数
    
    static double maxpitch;
    static double minpitch;
    static double neutralpitch;
    static double maxyaw;
    static double minyaw;
    static double neutralyaw;
    
    static double maxpitchdegree;
    static double neutralpitchdegree;
    static double minpitchdegree;
    static double neutralyawdegree;
    static double maxyawdegree;
    static double minyawdegree;
    
    static double maxpitchplayratio;
    static double minpitchplayratio;
    static double maxyawplayratio;
    static double minyawplayratio;
    
    static double trimpitchrate;
 
    static double pitch;
    static double pitchdegree;
    static int    inttrimpitch;
    static double yaw;
    static double yawdegree;
    static int    inttrimyaw;
    static double airspeed;
    static float cadence;
    static float ultsonic;
    static float powermeter;
//    static double atmpress;
    //static int    selector;
    static float cadencevolt;
    static float ultsonicvolt;
    static float powermetervolt;
    static double servovolt;
    static double miconvolt;
    
    static volatile int pitchtime;
    static volatile int pitchdegreetime;
    static volatile int inttrimpitchtime;
    static volatile int yawtime;
    static volatile int yawdegreetime;
    static volatile int inttrimyawtime;
    static volatile int airspeedtime;
    static volatile int cadencetime;
    static volatile int ultsonictime;
    static volatile int powermetertime;
//    static int atmpresstime;
    //static int selectortime;
    static volatile int cadencevolttime;
    static volatile int ultsonicvolttime;
    static volatile int powermetervolttime;
    static int servovolttime;
    static int miconvolttime;

    
    
    
    public :
    
    static Queue<char, 20> initqueue;
    static Queue<char, 20> displayqueue;
    
    static void initialize();
    static void fileread();
    static void filewrite();
    
    static const int rotateperrevolutions=12;
    static const int rotateperrevolutions_onepulse=1;
    
    static class Timer timer;
    //static class DigitalOut led; //led2を使うとflashが使えなくなる。
    static class FlashManager memory;

    
    static double getmaxpitch();
    static double getminpitch();
    static double getneutralpitch();
    static double getmaxyaw();
    static double getminyaw();
    static double getneutralyaw();

    static void setmaxpitch(double _maxpitch);
    static void setminpitch(double _minpitch);
    static void setneutralpitch(double _neutralpitch);
    static void setmaxyaw(double _maxyaw);
    static void setminyaw(double _minyaw);
    static void setneutralyaw(double _neutralyaw);
    
    static double getmaxpitchdegree();
    static double getneutralpitchdegree();
    static double getminpitchdegree();
    static double getmaxyawdegree();
    static double getneutralyawdegree();
    static double getminyawdegree();
    
    static void setmaxpitchdegree(double _maxpitchdegree);
    static void setneutralpitchdegree(double _neutralpitchdegree);
    static void setminpitchdegree(double _minpitchdegree);
    static void setmaxyawdegree(double _maxyawdegree);
    static void setneutralyawdegree(double _neutralyawdegree);
    static void setminyawdegree(double _minyawdegree);
    
    static double getmaxpitchplayratio();
    static double getminpitchplayratio();
    static double getmaxyawplayratio();
    static double getminyawplayratio();

    static void setmaxpitchplayratio(double _maxpitchplayratio);
    static void setminpitchplayratio(double _minpitchplayratio);
    static void setmaxyawplayratio(double _maxyawplayratio);
    static void setminyawplayratio(double _minyawplayratio);
    
    static double gettrimpitchrate();
    
    static void settrimpitchrate(double _trimpitchrate);
    
    
    static double getpitch();
    static double getpitchdegree();
    static int    getinttrimpitch();
    static double getyaw();
    static double getyawdegree();
    static int    getinttrimyaw();
    static double getairspeed();
    static float getcadence();
    static float getultsonic();
    static float getpowermeter();
//    static double getatmpress();
    //static int    getselector();
    static float getcadencevolt();
    static float getultsonicvolt();
    static double getservovolt();
    static double getmiconvolt();

    static int getpitchtime();
    static int getpitchdegreetime();
    static int getinttrimpitchtime();
    static int getyawtime();
    static int getyawdegreetime();
    static int getinttrimyawtime();
    static int getairspeedtime();
    static int getcadencetime();
    static int getultsonictime();
    static int getpowermetertime();
//    static int getatmpresstime();
    //static int getselectortime();
    static int getcadencevolttime();
    static int getultsonicvolttime();
    static int getservovolttime();
    static int getmiconvolttime();



    static void setpitch(double _pitch);
    static void setpitchdegree(double _pitchdegree);
    static void setinttrimpitch(int _inttrimpitch);
    static void setyaw(double _yaw);
    static void setyawdegree(double _yawdegree);
    static void setinttrimyaw(int _inttrimyaw);    
    static void setairspeed(double _airspeed);
    static void setcadence(float _cadence); //floatにかえる
    static void setultsonic(float _ultsonic);
    static void setpowermeter(float _powermeter);
//    static void setatmpress(double _atmpress);
    //static void setselector(int _selector);   
    static void setcadencevolt(float _cadencevolt);//floatにかえる
    static void setpowermetervolt(float _powermetervolt);
    static void setultsonicvolt(float _ultsonicvolt);
    static void setservovolt(double _servovolt);
    static void setmiconvolt(double _miconvolt);
};

#endif
