#ifndef BIRD_CONTROL_TRIM_H_
#define BIRD_CONTROL_TRIM_H_
#include "mbed.h"

class Trim{
    
    int _inttrim;
    bool upswstatus;
    bool downswstatus;

    DigitalIn _upsw;
    DigitalIn _downsw;
    Ticker ticker;
    
    void up();
    void down();
    void clamp(int &value, int min, int max);
    void clamp(double &value, double min, double max);
    double calc(int inttrim, double rate);
    void update();
    
    public:
    Trim(PinName upsw, PinName downsw);
    double get(double rate);
    int getint();
    
};
#endif