//@todo Initのコマンドモード化or別プログラム化
//@todo Initで設定した値の反映をスマートに（ServoMやControllerMでupdate毎にGlobalから設定値を取り込むのではなく，paramSet的な関数を作って更新時に呼び出し）
//てかそもそもInit情報Globalに入れる必要ないのでは？

//@todo Cadence, Airspeed内でNC，Encorderクラスから継承
//@todo Buttonクラスを作り，TrimとSelectorの親クラスにする

//@todo 使っているライブラリの関数の説明追加

//selector周りはコメントアウトしてます

//タスクの数に上限があるっぽい(6個以下)
//

#include "mbed.h"
#include "rtos.h"
#include "Global.h"
#include "Init.h"
#include "ServoSend.h"
#include "ControllerManager.h"
#include "Trim.h"
//#include "Airspeed.h"
//#include "Atmpress.h"  //2018年から廃止
#include "PitotAirspeed.h"
#include "Display.h"
//#include "Selector.h"
#include "TweLite_Sensors.h"

RawSerial pc(USBTX, USBRX);

/********************旧基盤**********************/
/*
Atmpress atmpress(PB_7, PA_15);//sda, scl
Display display(PC_4, PA_10, NC);//tx, rx, sw
ControllerManager controllerManager(PC_1,PC_0,PA_4,PA_1);//ele, rud, eletrimup, eletrimdown
ServoSend servoSend(PC_10, PC_11);//tx, rx
//Selector selector(p25);
DigitalOut wdt(PB_0); 
Airspeed airspeed(PC_13, NC, NC);//p19,p20をInterruptInに使ってはいけない
TweLite_Sensors tweLite_Sensors(PC_12,PD_2);
*/
/**********************************************/

/*****************新基盤*************************/
// Atmpress atmpress(PC_9, PA_8);//sda, scl //2018年から廃止
Display display(PB_9, PB_11, NC);//tx, rx, sw
ControllerManager controllerManager(PC_2,PC_3,PB_5,PB_4);//ele, rud, eletrimup, eletrimdown
/*
おそらくコメントele,rudが逆やと思う。
コメントに通りに配線したがele,rudが逆に作動しその動きを見て配線を逆にした結果正常な動きになったと思われる。
controllerManagerのcontrollerV.read()はpitchに対応し、Hはyawに対応している。
コンストラクタ引数の一つ目がｈ、二つ目がｖなのでrud,eleの順にpin指定すべきなきがする。。
確認して前のままで合ってたら無視して下さい
2017/10/12
*/
//RawSerial servoSerial(PC_12, PD_2);
//ServoSend servoSend(servoSerial);//tx, rx
ServoSend servoSend(PC_12, PD_2);//tx, rx
//Selector selector(p25);
DigitalOut wdt(PB_0);
//Airspeed airspeed(PB_8, NC, NC);//p19,p20をInterruptInに使ってはいけない
PitotAirspeed airspeed(PC_12, PD_2);
TweLite_Sensors tweLite_Sensors(PC_10,PC_11);
/***********************************************/


//FlashMemoryのpin指定は Global.cpp 内


//pcからのデータの受信があれば、それをitqueueにpush
//initqueueはInitクラスで使用
void pc_rx(){
    while(pc.readable()==1){
        //コマンドモードのon,offはここに入れるといい
        char buf = (char)pc.getc();
        pc.putc(buf);
        Global::initqueue.put((char*)buf);
    }
}



void initializeTask(void const *pvParameters){
    while(1){
        Init::getSerial();//pcからのコマンド入力
    }
}

void controlTask(void const *pvParameters){
    while(1){
        //この中でpc.printfはしないほうがいいみたい（9600bpsだと遅延が起こる）
        controllerManager.update();        //操縦桿からのデータを読み込み
        servoSend.send();                  //操縦桿からのデータを元にサーボに書き込み
        //selector.update();
        wdt = !wdt;//ウォッチドッグタイマのkickに相当
        Thread::wait(50); //2017は５０ms
    }
}

void sensorTask500(void const *pvParameters){
    while(1){
//        pc.printf("sensorTask500\n");
        airspeed.update();
        // atmpress.update();   // 2018年から廃止
        Thread::wait(100);
    }
}

void twesensorTask(void const *pvParameters){
    while(1){
        tweLite_Sensors.update();
        //こっちでそれぞれのbatteryをupdata
        //更新周期はTickerのインターバルで指定
    }
}


void displayTask(void const *pvParameters){
    while(1){
        display.update();
        Thread::wait(50);
    }   
}



int main(void){
    pc.baud(115200);
    pc.printf("start\n");
    pc.attach(pc_rx,Serial::RxIrq);                             //pcからの受信を検知（コマンド入力に使用)
    Global::initialize();                                       //ファイルからパラメータ読み込み
    Thread InitializeTask(initializeTask);                      //コマンドを解析してパラメータを更新するスレッド(使用可能なコマンドはinit.cpp参照)
    Thread ControlTask(controlTask, NULL, osPriorityRealtime);  //操縦桿からのデータを読み込んで、サーボに書き込むスレッド(優先度maxに設定されている)
    Thread SensorTask500(sensorTask500);                        //機速計・気圧計の値を更新するスレッド              
    Thread TwesensorTask(twesensorTask);                        //twelite経由で超音波計・回転数計の値を読み取るスレッド(wiki参照)
    Thread DisplayTask(displayTask);                            //bluetooth経由でタブレットにデータを送信するスレッド
    pc.printf("Task end\n");
    
    Thread::wait(osWaitForever);
}