#include "mbed.h"
#include "Trim.h"
#include "Global.h"
//PullUpに注意

#define STEP_MAX 13
#define STEP_MIN -13

Trim::Trim(PinName upsw, PinName downsw) 
: _upsw(upsw), _downsw(downsw){
    
    _upsw.mode(PullUp);
    _downsw.mode(PullUp);
    
    upswstatus = 1;
    downswstatus = 1;
        
    ticker.attach(this,&Trim::update,0.05);
}


void Trim::up(){
    _inttrim--;
    clamp(_inttrim,STEP_MIN,STEP_MAX);
//    printf("trim = %d\n",_inttrim);
}

void Trim::down(){
    _inttrim++;
    clamp(_inttrim,STEP_MIN,STEP_MAX);
//    printf("trim = %d\n",_inttrim);
}

void Trim::clamp(int &value, int min, int max){
    if(value < min) {
        value = min;
    } else if(value > max) {
        value = max;
    }
}

void Trim::clamp(double &value, double min, double max){
    if(value < min) {
        value = min;
    } else if(value > max) {
        value = max;
    }
}


double Trim::calc(int inttrim, double rate){
    return (double)inttrim*rate;
}

void Trim::update(){
    //この条件分岐はチャタリング対策。スイッチを押して離したタイミングでup()
    if(_upsw == 0){
        upswstatus = 0;
    }else if((_upsw == 1)&&(upswstatus == 0)){
        up();
        upswstatus = 1;
    }
    
    if(_downsw == 0){
        downswstatus = 0;
    }else if((_downsw == 1)&&(downswstatus == 0)){
        down();
        downswstatus = 1;
    }    
}

double Trim::get(double rate){
    return calc(_inttrim, rate);
}

int Trim::getint(){
    return _inttrim;    
}

