#include "mbed.h"
#include "Beep.h"

/**
 * Pseudo Theremin using Sharp IR Rangers + my A2D I2C adapters
 *
 * Demo Video: http://www.youtube.com/watch?v=6HEsA3RBoPc
 * A2D adapters: https://code.google.com/p/bot-thoughts-sharpi2c/
 *
 * One ranger controls pitch, the other on/off.
 * Simple PWM sound generation is used.  The output pin p22 feeds
 * into a simple common-emitter BJT amplifier on my breadboard.
 */
DigitalOut myled(LED1);
I2C i2c(p28, p27);       // sda, scl
Serial pc(USBTX, USBRX); // tx, rx
Timer t;
Beep buzzer(p22);

#define PITCH   0x26
#define PITCHR  (PITCH<<1)|1
#define PITCHW  (PITCH<<1)
#define VOLUME  0x27

int main() {
    int p = 0;
    int v = 0;
    
    i2c.frequency(100000);
    pc.baud(115200);
    pc.printf("Hello world!\n");
    t.start();
    t.reset();
    
    while(1) {
        char data[3];
        float range = 0.0;

        pc.printf("%8u ", t.read_ms());

        if ( i2c.read(VOLUME<<1, data, 2) != 0) {
            pc.printf("~0x%02x ", VOLUME);
        } else {
            v = data[0]<<8 | data[1];
            pc.printf("%03u %03u v=%u ", data[0], data[1], v);
        }            

        if ( i2c.read(PITCHR, data, 2) != 0) {
            pc.printf("~0x%02x", PITCH);
        } else {
            p = data[0]<<8 | data[1];
            if (v > 2300){
                range = 500 + 500 * powf(4187.8 / p, 1.1060);
                buzzer.beep(int(range));
            } else {
                buzzer.nobeep();
            }
            pc.printf("%03u %03u p=%u r=%f", data[0], data[1], p, range);
        }
        pc.printf("\n");

        wait(0.005);
    }
}
