#include "IncrementalEncoder.h"

IncrementalEncoder::IncrementalEncoder(PinName pin):  _lastTicks(0),  _ticks(0), _interrupt(pin) {
    _interrupt.mode(PullNone); // default is pulldown but my encoder board uses a pull-up and that just don't work
    _interrupt.rise(callback(this, &IncrementalEncoder::_increment)); 
    _interrupt.fall(callback(this, &IncrementalEncoder::_increment)); 
}

unsigned int IncrementalEncoder::read() {
// disable interrupts?
    unsigned int ticks = _ticks - _lastTicks;
    _lastTicks = _ticks;
    
    return ticks;
}    

unsigned int IncrementalEncoder::readTotal() {
    return _ticks;
}

    
void IncrementalEncoder::reset() {
    _ticks = _lastTicks = 0;
}  


void IncrementalEncoder::_increment() {
    _ticks++;
}