#include "Logger.h"
#include <stdio.h>
#include <algorithm>
#include <vector>
#include <iterator>
#include <string>

Logger::Logger() {
    _file = NULL;
    _fp = NULL;
}


void Logger::start() {
    if (_fp == NULL) {
        DIR *d;
        char file[24];
        std::vector<string> fl;
        dirent *p;
        
        if ((d = opendir("/log")) != NULL) {
            while ((p = readdir(d)) != NULL) {
                fl.push_back(string(p->d_name));
            }
            closedir(d);
            
            // Open a new unique log file of the form NNNN.csv
            for (int i=0; i <= 9999; i++) {
                sprintf(file, "%04d.CSV", i);   // generate filename
                string x(file);                 // create string version
                // Is this filename NOT listed in the directory?
                if (std::find(fl.begin(), fl.end(), x) == fl.end()) {
                    x.insert(0, "/log/"); // prepend the correct path
                    if ((_fp = fopen(x.c_str(), "w")) == NULL) {
                        fprintf(stdout, "%s: cannot open\n", file);
                    } else {
                        fprintf(stdout, "%s: opened\n", file);
                    }
                    break;
                }// if
            }// for
        }// if
    } // if
}


void Logger::stop() {
    if (_fp && fclose(_fp) != EOF) {
        _fp = NULL;
    }
}


bool Logger::enabled() {
    return (_fp != NULL);
}


void Logger::log_gps(GpsData d) {
    if (enabled()) {
        fprintf(_fp, "G,%llu,%3.9f,%3.9f,%3.1f,%2.1f,%2.1f,%d\n",
            d.timestamp,
            d.latitude, 
            d.longitude,
            d.course,
            d.speed,
            d.hdop,
            d.svcount
        );
    }
}


void Logger::log_sensors(SensorData d) {
    if (enabled()) {
        fprintf(_fp, "S,%llu,%u,%d,%d,%d,%d,%d,%d,%d,%d,%d\n",
            d.timestamp,
            d.encoder, 
            d.gyro[0],
            d.gyro[1],
            d.gyro[2],
            d.accel[0],
            d.accel[1],
            d.accel[2],
            d.mag[0],
            d.mag[1],
            d.mag[2]            
        );       
    }
}


void Logger::log_estimation() {
    if (enabled()) {
    }
}