#ifndef __UBLOX6_H
#define __UBLOX6_H

/** uBlox GPS UBX Protocol Reader
 * Parses uBlox GPS binary protocol
 * 
 * @author Wayne Holder; Ported to mbed by Michael Shimniok
 */
#include "mbed.h"

class Ublox6 {
public:
    // TODO 3 convert this to time units
    // TODO 3 move this somewhere else?
    static const int lag=40;        // number of updater steps by which gps output lags reality

    Ublox6();

    /**
     * UBX protocol parser (Wayne Holder)
     * @param cc is the character to parse
     * @return 1 when entire packet of data obtained, 0  otherwise
     */    
    int parse(int cc);

    void subscribe(Callback<void()> cb);

    /** Read the latest data from GPS
     * @param lat latitude in degrees
     * @param lon longitude in degrees
     * @param course heading/course in degrees
     * @param speed speed m/s
     * @return all parameters
     */
    void read(double& lat, double& lon, float& course, float& speed, float& hdop, int& svcount);

private:
    typedef struct {
        double lat;
        double lon;
        float course;
        float speed;
        float hdop;
        int svcount;
    } gps_data_t;

    gps_data_t tmp;
    gps_data_t latest;

    int _ready;             // is data ready to be copied?
    bool _available;        // 

    Callback<void()> _callback;

    /*
    float _latitude;        // temp storage, latitude
    float _longitude;       // temp storage, longitude
    float _hdop;            // horiz dilution of precision
    float _course_deg;      // course in degrees
    float _speed_mps;       // speed in m/s
    int _svcount;           // space vehicle (satellite) count
    */
};

#endif
