#ifndef __GPS_H
#define __GPS_H

/** GPS interface class for character-at-a-time parsing of GPS protocols
 * @author Michael Shimniok
 */
class GPS {
public:
    /// struct containing year, month, date, hour, minute, second, lat, lon, course, speed, hdop, svcount
    typedef struct {
        int year;
        int month;
        int date;
        int hour;
        int minute;
        int second;
        double lat;
        double lon;
        float course;
        float speed;
        float hdop;
        int svcount;
    } gps_data_t;

#ifdef __MBED__
    GPS(): _callback(0) {}
#else
    GPS() {}
#endif

    /** Parse one character of protocol
     * @param c is the character to parse
     * @return 1 when entire packet of data obtained, 0 otherwise
     */
    virtual int parse(char c) = 0;

#ifdef __MBED__
    void subscribe(Callback<void()> cb) {
        _callback = cb;
    }
#endif

    /** Read the latest data from GPS
     * @returns gps_data_t struct with date, time, position, course, speed, hdop, and svcount
     */
    gps_data_t read() {
        return latest;
    }

protected:
    gps_data_t latest;
    gps_data_t tmp;

#ifdef __MBED__
    Callback<void()> _callback;
#endif
};

#endif
