#include "Display.h"
#include <string.h>

#define LCDWIDTH 21

Display::Display(PinName tx, PinName rx)
{
    lcd = new SerialGraphicLCD(tx, rx);
    lcd->clear();
}


void Display::gps(GpsData d)
{
    lcd->pos(0,6);
    lcd->printf("lat: %12.7f ", d.latitude);
    lcd->pos(0,5);
    lcd->printf("lon: %12.7f ", d.longitude);
    lcd->pos(0,4);
    lcd->printf("sv:%-2d h:%-3.0f s:%-4.1f ", d.svcount, d.course, d.speed);
}


void Display::imu(SensorData d) 
{
    lcd->pos(0,3);
    lcd->printf("gyr: z:%4d ", d.gyro[2]);
    lcd->pos(0,2);
    lcd->printf("acc: x:%4d y:%4d ", d.accel[0], d.accel[1]);
    lcd->pos(0,1);
    lcd->printf("mag: x:%4d y:%4d ", d.mag[0], d.mag[1]);
}


void Display::cpu(int idle)
{
    lcd->pos(13,7);
    lcd->printf("idle:%3d%%", idle);
}


void Display::status(char *s) 
{
    char line[LCDWIDTH+1];
    int i;
    int len = strlen(s);

    for (i = 0; i < LCDWIDTH; i++) {
        if (i < len) {
            line[i] = s[i];
        } else {
            line[i] = ' ';
        }
    }
    line[LCDWIDTH] = 0;
    
    lcd->pos(0,7);
    // TODO: limit string length
    lcd->printf(line);
}
